/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.scenegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.media.opengl.GL2;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.rendering.material.HasCullMode;
import tazadum.engine.rendering.material.HasEmittance;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.material.MaterialTransform;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.SceneGraph;
import tazadum.engine.rendering.shader.MaterialShader;

public class SceneGraphImpl
implements SceneGraph {
    private final Node<MeshNode> world = new Node<Object>(null);
    private MaterialShader activeShader = null;
    private final List<Node<MeshNode>> nodes = new ArrayList<Node<MeshNode>>();
    private final Comparator<Node<MeshNode>> material_comparator = new Comparator<Node<MeshNode>>(){

        @Override
        public int compare(Node<MeshNode> node, Node<MeshNode> node2) {
            Material material = node.getData().getMaterial();
            Material material2 = node2.getData().getMaterial();
            if (material.priority() == material2.priority()) {
                return material.getShader().hashCode() - material2.getShader().hashCode();
            }
            return material.priority() - material2.priority();
        }
    };

    @Inject
    public SceneGraphImpl() {
    }

    @Override
    public Node<MeshNode> getWorld() {
        return this.world;
    }

    @Override
    public void render(GL2 gL2, Camera camera, MaterialTransform materialTransform, boolean bl) {
        gL2.glEnable(2929);
        gL2.glEnable(2884);
        gL2.glCullFace(1029);
        this.activeShader = null;
        this.renderByMaterial(gL2, this.world, camera, materialTransform, bl);
    }

    @Override
    public void calculateTransformations() {
        this.precalcTransformations(this.world, this.world.getMatrix());
    }

    private void precalcTransformations(Node<MeshNode> node, Matrix4f matrix4f) {
        for (Node<MeshNode> node2 : node.getChildren()) {
            node2.getMatrix().set(matrix4f).multLocal(node2.getTransform());
            if (node2.isLeaf()) continue;
            this.precalcTransformations(node2, node2.getMatrix());
        }
    }

    private void renderByMaterial(GL2 gL2, Node<MeshNode> node, Camera camera, MaterialTransform materialTransform, boolean bl) {
        this.nodes.clear();
        this.addNodes(this.nodes, node);
        Collections.sort(this.nodes, this.material_comparator);
        for (Node<MeshNode> node2 : this.nodes) {
            this.renderNode(gL2, node2, camera, materialTransform, bl);
        }
        if (this.activeShader != null) {
            this.activeShader.disable(gL2);
        }
    }

    private void addNodes(List<Node<MeshNode>> list, Node<MeshNode> node) {
        if (node.hasData()) {
            list.add(node);
        }
        if (!node.isLeaf()) {
            for (Node<MeshNode> node2 : node.getChildren()) {
                this.addNodes(list, node2);
            }
        }
    }

    private void renderNode(GL2 gL2, Node<MeshNode> node, Camera camera, MaterialTransform materialTransform, boolean bl) {
        MaterialShader materialShader;
        Material material;
        MeshNode meshNode = node.getData();
        Mesh mesh = meshNode.getMesh();
        Material material2 = material = materialTransform == null ? meshNode.getMaterial() : materialTransform.map(meshNode.getMaterial());
        if (material instanceof HasEmittance) {
            ((HasEmittance)((Object)material)).useEmittance(bl);
        }
        if (!(materialShader = material.getShader()).equals(this.activeShader)) {
            if (this.activeShader != null) {
                this.activeShader.disable(gL2);
            }
            materialShader.enable(gL2);
            this.activeShader = materialShader;
            materialShader.bindProjection(gL2, camera.getProjection());
            materialShader.bindView(gL2, camera.getView());
        }
        materialShader.populate(gL2, material, mesh);
        materialShader.bindModel(gL2, node.getMatrix());
        if (material instanceof HasCullMode && ((HasCullMode)((Object)material)).isTwoSided()) {
            gL2.glDisable(2884);
        } else {
            gL2.glEnable(2884);
        }
        mesh.draw(gL2);
    }
}

