/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.shader;

import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.shader.Shader;
import tazadum.engine.rendering.shader.ShaderHelper;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.util.Logger;

public class BlurShader
implements LifeCycle,
Shader {
    private static final String VERTEX_PROGRAM = "resources/shaders/blur.vertex.glsl";
    private static final String FRAGMENT_PROGRAM = "resources/shaders/blur.fragment.glsl";
    private final ResourceManager resourceManager;
    private int vertexShader;
    private int fragmentShader;
    private int program;
    private int locVertex;
    private int locTexture0;
    private int locTextureCoord0;
    private int locDirection;
    private int locSize;

    @Inject
    public BlurShader(LifeCycleManager lifeCycleManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        lifeCycleManager.add(this);
    }

    @Override
    public void onInit(GL gL) {
        if (!gL.isGL2()) {
            System.out.println("GL2 not supported");
            return;
        }
        GL2 gL2 = gL.getGL2();
        byte[] byArray = this.resourceManager.load(VERTEX_PROGRAM);
        byte[] byArray2 = this.resourceManager.load(FRAGMENT_PROGRAM);
        this.vertexShader = ShaderHelper.compile(gL2, 35633, new String(byArray));
        this.fragmentShader = ShaderHelper.compile(gL2, 35632, new String(byArray2));
        this.program = gL2.glCreateProgram();
        gL2.glAttachShader(this.program, this.vertexShader);
        gL2.glAttachShader(this.program, this.fragmentShader);
        gL2.glLinkProgram(this.program);
        int[] nArray = new int[1];
        gL2.glGetProgramiv(this.program, 35714, nArray, 0);
        if (nArray[0] != 1) {
            Logger.log("Linking shader failed: %s", ShaderUtil.getProgramInfoLog((GL)gL2, (int)this.program));
            throw new IllegalArgumentException("Could not link program");
        }
        this.locVertex = gL2.glGetAttribLocation(this.program, "a_position");
        this.locTextureCoord0 = gL2.glGetAttribLocation(this.program, "a_texture0");
        this.locTexture0 = gL2.glGetUniformLocation(this.program, "u_texture0");
        this.locDirection = gL2.glGetUniformLocation(this.program, "u_direction");
        this.locSize = gL2.glGetUniformLocation(this.program, "u_size");
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void enable(GL2 gL2) {
        gL2.glUseProgram(this.program);
    }

    @Override
    public void disable(GL2 gL2) {
        gL2.glUseProgram(0);
    }

    public void bindVertices(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locVertex);
        gL2.glVertexAttribPointer(this.locVertex, 3, 5126, false, 12, (Buffer)floatBuffer);
    }

    public void bindTextureCoords(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locTextureCoord0);
        gL2.glVertexAttribPointer(this.locTextureCoord0, 2, 5126, false, 8, (Buffer)floatBuffer);
    }

    public void bindTexture0(GL2 gL2, int n) {
        gL2.glActiveTexture(33988);
        gL2.glBindTexture(3553, n);
        gL2.glUniform1i(this.locTexture0, 4);
    }

    public void bindDirection(GL2 gL2, float f, float f2) {
        gL2.glUniform2f(this.locDirection, f, f2);
    }

    public void bindSize(GL2 gL2, float f) {
        gL2.glUniform1f(this.locSize, f);
    }
}

