/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.resource.selector;

import java.util.regex.Pattern;
import tazadum.engine.resource.selector.Selector;

public class FilePatternSelector
implements Selector {
    private static final Pattern doubleStar = Pattern.compile("\\*\\*", 32);
    private static final Pattern singleStar = Pattern.compile("\\*", 32);
    private static final Pattern quote = Pattern.compile("\\.", 32);
    private Pattern directoryRegex;
    private Pattern fileRegex;
    private String basedir;

    public FilePatternSelector(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            String string2 = this.applySingleStar(this.quote(string.substring(n + 1)));
            this.fileRegex = Pattern.compile(string2);
            String string3 = string.substring(0, n);
            String string4 = this.applyDoubleStar(this.quote(string3));
            this.directoryRegex = Pattern.compile(string4);
            this.findBasedir(string3);
        } else {
            String string5 = this.applyDoubleStar(this.quote(string));
            this.directoryRegex = Pattern.compile(string5);
            this.findBasedir(string);
        }
    }

    private void findBasedir(String string) {
        int n = string.indexOf("**");
        if (n < 0) {
            this.basedir = string;
            return;
        }
        if (n == 0) {
            this.basedir = ".";
            return;
        }
        this.basedir = string.substring(0, n);
        if (this.basedir.endsWith("/")) {
            this.basedir = this.basedir.substring(0, this.basedir.length() - 1);
        }
    }

    private String quote(String string) {
        return quote.matcher(string).replaceAll("\\\\.");
    }

    private String applySingleStar(String string) {
        return singleStar.matcher(string).replaceAll(".*");
    }

    private String applyDoubleStar(String string) {
        return doubleStar.matcher(string).replaceAll(".*");
    }

    @Override
    public boolean selects(String string, String string2) {
        if (string == null) {
            string = "";
        }
        boolean bl = this.directoryRegex.matcher(string).matches();
        if (this.fileRegex == null) {
            return bl;
        }
        if (string2 == null) {
            string2 = "";
        }
        return this.fileRegex.matcher(string2).matches();
    }

    @Override
    public String basedir() {
        return this.basedir;
    }
}

