/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import javax.media.opengl.awt.GLCanvas;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.tween.PointType;
import tazadum.engine.math.tween.Tween;
import tazadum.engine.math.tween.TweenPoint;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.parameter.Tween3fParameter;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.CameraControl;

public class CameraControlImpl
implements CameraControl {
    private final RenderEngine renderEngine;
    private final TimeManager timeManager;
    private final ParameterFactory parameterFactory;
    private final float speed = 50.0f;
    private boolean editMode;
    private boolean pressed;
    private int referenceX;
    private int referenceY;
    private final boolean[] keystate = new boolean[256];
    private Tween3fParameter cameraDirection;
    private Tween3fParameter cameraPosition;
    private float t0;

    @Inject
    public CameraControlImpl(RenderEngine renderEngine, ParameterFactory parameterFactory, TimeManager timeManager) {
        this.renderEngine = renderEngine;
        this.parameterFactory = parameterFactory;
        this.timeManager = timeManager;
    }

    @Override
    public void initialize(GLCanvas gLCanvas, boolean bl) {
        if (!bl) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "blank cursor");
        gLCanvas.setCursor(cursor);
        gLCanvas.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!CameraControlImpl.this.pressed) {
                    return;
                }
                int n = mouseEvent.getX() - CameraControlImpl.this.referenceX;
                int n2 = mouseEvent.getY() - CameraControlImpl.this.referenceY;
                CameraControlImpl.this.rotateCamera(n, n2);
                CameraControlImpl.this.referenceX = mouseEvent.getX();
                CameraControlImpl.this.referenceY = mouseEvent.getY();
            }
        });
        gLCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CameraControlImpl.this.pressed = true;
                CameraControlImpl.this.referenceX = mouseEvent.getX();
                CameraControlImpl.this.referenceY = mouseEvent.getY();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CameraControlImpl.this.pressed = false;
            }
        });
        gLCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ((CameraControlImpl)CameraControlImpl.this).keystate[keyEvent.getKeyChar() & 0xFF] = true;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ((CameraControlImpl)CameraControlImpl.this).keystate[keyEvent.getKeyChar() & 0xFF] = false;
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == 'q') {
                    CameraControlImpl.this.recordCamera();
                }
            }
        });
    }

    protected void recordCamera() {
        float f = this.timeManager.getTime() - this.t0;
        Camera camera = this.renderEngine.getCamera();
        PointType pointType = PointType.Curve;
        Vector3f vector3f = camera.getDirection();
        List<Tween> list = this.cameraDirection.getTweens();
        list.get(0).addPoint(new TweenPoint(new Vector2f(f, vector3f.x), pointType));
        list.get(1).addPoint(new TweenPoint(new Vector2f(f, vector3f.y), pointType));
        list.get(2).addPoint(new TweenPoint(new Vector2f(f, vector3f.z), pointType));
        Vector3f vector3f2 = camera.getPosition();
        List<Tween> list2 = this.cameraPosition.getTweens();
        list2.get(0).addPoint(new TweenPoint(new Vector2f(f, vector3f2.x), pointType));
        list2.get(1).addPoint(new TweenPoint(new Vector2f(f, vector3f2.y), pointType));
        list2.get(2).addPoint(new TweenPoint(new Vector2f(f, vector3f2.z), pointType));
    }

    protected void rotateCamera(int n, int n2) {
        Camera camera = this.renderEngine.getCamera();
        Vector3f vector3f = new Vector3f(camera.getDirection());
        Vector3f vector3f2 = camera.getDirection().cross(Vector3f.UNIT_Y).normalizeLocal();
        Quaternion quaternion = new Quaternion().fromAngleNormalAxis(0.005f * (float)n, Vector3f.UNIT_Y);
        Quaternion quaternion2 = new Quaternion().fromAngleNormalAxis(-0.005f * (float)n2, vector3f2);
        quaternion2.multLocal(quaternion).multLocal(vector3f);
        camera.lookAt(Vector3f.UNIT_Y, vector3f.addLocal(camera.getPosition()));
    }

    @Override
    public void update(float f) {
        Vector3f vector3f;
        Camera camera;
        if (this.keystate[119]) {
            camera = this.renderEngine.getCamera();
            camera.getPosition().addLocal(camera.getDirection().mult(50.0f * f));
            camera.update();
        }
        if (this.keystate[115]) {
            camera = this.renderEngine.getCamera();
            camera.getPosition().addLocal(camera.getDirection().mult(-50.0f * f));
            camera.update();
        }
        if (this.keystate[97]) {
            camera = this.renderEngine.getCamera();
            vector3f = camera.getDirection().cross(Vector3f.UNIT_Y).normalizeLocal();
            camera.getPosition().addLocal(vector3f.mult(25.0f * f));
            camera.update();
        }
        if (this.keystate[100]) {
            camera = this.renderEngine.getCamera();
            vector3f = camera.getDirection().cross(Vector3f.UNIT_Y).normalizeLocal();
            camera.getPosition().addLocal(vector3f.mult(-25.0f * f));
            camera.update();
        }
    }

    @Override
    public void registerParameters(Object object, String string) {
        this.registerParameters(object, string, 0.0f);
    }

    @Override
    public void registerParameters(Object object, String string, float f) {
        this.t0 = f;
        this.cameraDirection = (Tween3fParameter)this.parameterFactory.tween3f(object, string + "-cam-dir");
        this.cameraPosition = (Tween3fParameter)this.parameterFactory.tween3f(object, string + "-cam-pos");
    }

    @Override
    public void positionCamera(float f) {
        if (this.editMode || this.cameraDirection == null) {
            return;
        }
        Camera camera = this.renderEngine.getCamera();
        camera.moveTo(this.cameraPosition.get(f)).lookIn(Vector3f.UNIT_Y, this.cameraDirection.get(f));
        camera.update();
    }

    @Override
    public void toggleEditMode() {
        this.editMode = !this.editMode;
    }
}

