/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tazadum.engine.configuration.ConfigurationManager;
import tazadum.engine.configuration.ParameterManager;
import tazadum.engine.parameter.ConstantColorParameter;
import tazadum.engine.parameter.ConstantFloatParameter;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.SplineVector3Parameter;
import tazadum.engine.parameter.TweenParameter;
import tazadum.engine.parameter.TweenVector3Parameter;
import tazadum.engine.ui.ParameterGroup;
import tazadum.engine.ui.event.LayerEntrySelectedEvent;
import tazadum.engine.ui.event.ParametersReloadedEvent;
import tazadum.engine.ui.parameter.ConstantColorParameterUI;
import tazadum.engine.ui.parameter.ConstantFloatParameterUI;
import tazadum.engine.ui.parameter.SplineVector3ParameterUI;
import tazadum.engine.ui.parameter.TweenParameterUI;
import tazadum.engine.ui.parameter.TweenVectorParameterUI;
import tazadum.engine.util.event.EventBus;

public class ParameterView
extends JPanel
implements LayerEntrySelectedEvent.Handler {
    public static final int HEIGHT = 300;
    public static final Font HEADER_FONT = new Font("Areal", 0, 16);
    private final GridBagLayout gridBag;
    private final ParameterManager parameterManager;

    public ParameterView(final EventBus eventBus, final ConfigurationManager configurationManager) {
        this.parameterManager = configurationManager.getParameterManager();
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Save");
        JButton jButton2 = new JButton("Load");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                configurationManager.getParameterManager().saveAll();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                configurationManager.getParameterManager().reload();
                eventBus.fireEvent(new ParametersReloadedEvent());
            }
        });
        eventBus.addHandler(LayerEntrySelectedEvent.TYPE, this);
    }

    @Override
    public void onEntrySelected(LayerEntrySelectedEvent layerEntrySelectedEvent) {
        this.removeAll();
        ParameterGroup parameterGroup = this.parameterManager.getParameters(layerEntrySelectedEvent.getEntry());
        if (parameterGroup != null) {
            for (Map.Entry<String, Parameter<?>> entry : parameterGroup.getParameters()) {
                Parameter<?> parameter;
                String string = entry.getKey();
                JPanel jPanel = this.getParameterPanel(string, parameter = entry.getValue());
                if (jPanel == null) {
                    throw new RuntimeException("No UI panel exists for class " + parameter);
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 5, 0, 5);
                gridBagConstraints.anchor = 11;
                this.add((Component)this.addHeader(string, jPanel), gridBagConstraints);
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private JPanel getParameterPanel(String string, Parameter<?> parameter) {
        if (TweenParameter.class.isAssignableFrom(parameter.getClass())) {
            return new TweenParameterUI(string, parameter);
        }
        if (ConstantFloatParameter.class.equals(parameter.getClass())) {
            return new ConstantFloatParameterUI(parameter);
        }
        if (ConstantColorParameter.class.equals(parameter.getClass())) {
            return new ConstantColorParameterUI(parameter);
        }
        if (SplineVector3Parameter.class.equals(parameter.getClass())) {
            return new SplineVector3ParameterUI(parameter);
        }
        if (TweenVector3Parameter.class.equals(parameter.getClass())) {
            return new TweenVectorParameterUI(parameter);
        }
        return null;
    }

    private JPanel addHeader(String string, JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        JLabel jLabel = new JLabel(string2, 0);
        jLabel.setFont(HEADER_FONT);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }
}

