/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SpringLayout;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.UISize;
import tazadum.engine.ui.event.TimeTickEvent;
import tazadum.engine.ui.header.HeaderView;
import tazadum.engine.ui.layer.LayerView;
import tazadum.engine.ui.timeline.TimelineView;
import tazadum.engine.util.event.EventBus;

public class TimelineLayerPanel
extends JPanel {
    private final JPanel corner;
    private final TimelineView timeline;
    private final HeaderView headers;
    private final LayerView layers;

    @Inject
    public TimelineLayerPanel(EventBus eventBus, TimeManager timeManager, TimelineManager timelineManager) {
        Dimension dimension = new Dimension(UISize.Header.w + 20, UISize.Timeline.h);
        this.corner = new JPanel(new BorderLayout());
        this.corner.setMinimumSize(dimension);
        this.corner.setPreferredSize(dimension);
        this.corner.setMaximumSize(dimension);
        final JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(new Font("Monospaced", 0, 24));
        final JLabel jLabel2 = new JLabel();
        this.corner.add((Component)jLabel, "Center");
        this.corner.add((Component)jLabel2, "Last");
        eventBus.addHandler(TimeTickEvent.TYPE, new TimeTickEvent.Handler(){

            @Override
            public void onTimelineRepaint(TimeTickEvent timeTickEvent) {
                int n = (int)(timeTickEvent.getTime() / 60.0f);
                float f = timeTickEvent.getTime() - (float)(60 * n);
                jLabel.setText(String.format("%d:%02d.%02d", n, (int)f, (int)((f - (float)((int)f)) * 100.0f)));
                jLabel.setToolTipText(String.format("%.2f seconds", Float.valueOf(timeTickEvent.getTime())));
                jLabel2.setText(String.format("fps: %.0f", Float.valueOf(timeTickEvent.getFps())));
            }
        });
        this.add(this.corner);
        this.timeline = new TimelineView(eventBus, timelineManager, timeManager);
        this.headers = new HeaderView(eventBus, timelineManager, this.timeline, timeManager);
        this.layers = this.headers.getLayerView();
        JScrollBar jScrollBar = this.timeline.getScrollBar();
        JScrollBar jScrollBar2 = this.headers.getScrollBar();
        this.add(jScrollBar2);
        this.add(jScrollBar);
        this.add(this.timeline);
        this.add(this.headers);
        this.add(this.layers);
        SpringLayout springLayout = new SpringLayout();
        springLayout.putConstraint("West", (Component)this.corner, 0, "West", (Component)this);
        springLayout.putConstraint("North", (Component)this.corner, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.timeline, 2, "East", (Component)this.corner);
        springLayout.putConstraint("North", (Component)this.timeline, 0, "North", (Component)this);
        springLayout.putConstraint("East", (Component)this.timeline, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)this.timeline, 0, "South", (Component)this.corner);
        springLayout.putConstraint("West", (Component)jScrollBar2, 0, "West", (Component)this);
        springLayout.putConstraint("North", (Component)jScrollBar2, 2, "South", (Component)this.corner);
        springLayout.putConstraint("South", (Component)jScrollBar2, 0, "North", (Component)jScrollBar);
        springLayout.putConstraint("West", (Component)jScrollBar, 0, "East", (Component)jScrollBar2);
        springLayout.putConstraint("East", (Component)this, 0, "East", (Component)jScrollBar);
        springLayout.putConstraint("South", (Component)jScrollBar, 0, "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.headers, 2, "East", (Component)jScrollBar2);
        springLayout.putConstraint("North", (Component)this.headers, 2, "South", (Component)this.timeline);
        springLayout.putConstraint("East", (Component)this.headers, 0, "East", (Component)this.corner);
        springLayout.putConstraint("South", (Component)this.headers, -2, "South", (Component)jScrollBar2);
        springLayout.putConstraint("West", (Component)this.layers, 2, "East", (Component)this.headers);
        springLayout.putConstraint("North", (Component)this.layers, 2, "South", (Component)this.timeline);
        springLayout.putConstraint("East", (Component)this.layers, 0, "East", (Component)this);
        springLayout.putConstraint("South", (Component)this.layers, -2, "South", (Component)jScrollBar2);
        this.setLayout(springLayout);
    }
}

