/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tazadum.engine.parameter.ConstantColorParameter;
import tazadum.engine.parameter.Parameter;

public class ConstantColorParameterUI
extends JPanel {
    private final ConstantColorParameter parameter;
    private final JComponent colorBox;
    private final JLabel hexColor;

    public ConstantColorParameterUI(Parameter<?> parameter) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.parameter = (ConstantColorParameter)parameter;
        this.colorBox = new ColorBox();
        this.colorBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConstantColorParameterUI.this.spawnColorChooser();
            }
        });
        this.hexColor = new JLabel();
        this.toText(this.parameter.getValue());
        this.add(this.hexColor);
        this.add(this.colorBox);
    }

    protected void spawnColorChooser() {
        Color color = JColorChooser.showDialog(this, "Choose Color", new Color(this.parameter.getValue()));
        if (color != null) {
            this.parameter.setValue(color.getRGB());
            this.toText(color.getRGB());
            this.colorBox.repaint();
        }
    }

    private void toText(int n) {
        this.hexColor.setText(String.format("0x%06x", n));
    }

    private class ColorBox
    extends JPanel {
        public ColorBox() {
            Dimension dimension = new Dimension(32, 32);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.setMaximumSize(dimension);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(new Color(ConstantColorParameterUI.this.parameter.get(0.0f)));
            Rectangle rectangle = graphics.getClipBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

