/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.tween;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.tween.PointType;
import tazadum.engine.math.tween.Tween;
import tazadum.engine.math.tween.TweenPoint;
import tazadum.engine.ui.parameter.Grid;
import tazadum.engine.ui.parameter.GridControl;
import tazadum.engine.ui.tween.TweenViewDrawer;
import tazadum.engine.ui.tween.TweenViewPath;

public class TweenView
extends JPanel
implements ActionListener {
    private static final int TOKEN = 4;
    private static final Color[] COLORS = new Color[]{Color.blue, Color.green, Color.red, Color.white};
    private static final String[] TWEEN_NAMES = new String[]{"Blue", "Green", "Red", "White"};
    private final Grid grid;
    private final GridControl control;
    private final List<TweenViewPath> paths;
    private final Vector2f mouse = new Vector2f();
    private TweenViewPath activePath;
    private TweenPoint menuPoint;
    private TweenPoint activePoint;
    private Vector2f activePosition;
    private Point activeType;
    private JMenu itemType;
    private JMenuItem itemValue;
    private JMenuItem itemInterpolation;
    private JMenuItem itemCurve;
    private JMenu itemAdd;
    private JMenuItem itemDelete;
    private JMenuItem[] addItems;
    private final Vector2f menuInvocation = new Vector2f();

    public TweenView(Collection<Tween> collection) {
        if (collection.isEmpty() || collection.size() > 4) {
            throw new UnsupportedOperationException("The number of tweens must be between 1 and 4");
        }
        this.grid = new Grid();
        this.control = new GridControl(this, this.grid);
        int n = 0;
        this.paths = new ArrayList<TweenViewPath>(collection.size());
        for (Tween tween : collection) {
            TweenViewDrawer tweenViewDrawer = new TweenViewDrawer(4, this.grid, COLORS[n++]);
            this.paths.add(new TweenViewPath(tween, tweenViewDrawer));
        }
        this.itemType = new JMenu("Type");
        this.itemValue = new JMenuItem("Straight");
        this.itemInterpolation = new JMenuItem("Interpolation");
        this.itemCurve = new JMenuItem("Curve");
        this.itemAdd = new JMenu("Add");
        this.itemDelete = new JMenuItem("Delete");
        this.itemType.add(this.itemValue);
        this.itemType.add(this.itemInterpolation);
        this.itemType.add(this.itemCurve);
        this.itemValue.addActionListener(this);
        this.itemInterpolation.addActionListener(this);
        this.itemCurve.addActionListener(this);
        this.itemDelete.addActionListener(this);
        this.addItems = new JMenuItem[this.paths.size()];
        for (int i = 0; i < this.paths.size(); ++i) {
            this.addItems[i] = new JMenuItem(TWEEN_NAMES[i]);
            this.addItems[i].addActionListener(this);
            this.itemAdd.add(this.addItems[i]);
        }
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = -1;
                switch (keyEvent.getKeyCode()) {
                    case 49: {
                        n = 0;
                        break;
                    }
                    case 50: {
                        n = 1;
                        break;
                    }
                    case 51: {
                        n = 2;
                        break;
                    }
                    case 52: {
                        n = 3;
                        break;
                    }
                    case 69: {
                        if (TweenView.this.activePoint == null) break;
                        int n2 = (((TweenView)TweenView.this).activePoint.getType().id + 1) % PointType.values().length;
                        TweenView.this.activePoint.setType(PointType.fromId(n2));
                        TweenView.this.repaint();
                    }
                }
                if (n >= 0 && n < TweenView.this.paths.size()) {
                    Vector2f vector2f = TweenView.this.grid.screenToGrid(TweenView.this.mouse);
                    TweenViewPath tweenViewPath = (TweenViewPath)TweenView.this.paths.get(n);
                    tweenViewPath.getTween().addPoint(new TweenPoint(vector2f, PointType.Interpolation));
                    TweenView.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ((TweenView)TweenView.this).mouse.x = mouseEvent.getX();
                ((TweenView)TweenView.this).mouse.y = mouseEvent.getY();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (TweenView.this.activePoint == null) {
                    return;
                }
                int n = (int)(((TweenView)TweenView.this).mouse.x - (float)mouseEvent.getX());
                int n2 = (int)(((TweenView)TweenView.this).mouse.y - (float)mouseEvent.getY());
                if (n == 0 && n2 == 0) {
                    return;
                }
                boolean bl = (mouseEvent.getModifiersEx() & 0x80) != 0;
                boolean bl2 = (mouseEvent.getModifiersEx() & 0x40) != 0;
                TweenView.this.moveActivePoint(mouseEvent.getX(), mouseEvent.getY(), bl, bl2);
                TweenView.this.activePath.update();
                ((TweenView)TweenView.this).mouse.x = mouseEvent.getX();
                ((TweenView)TweenView.this).mouse.y = mouseEvent.getY();
                TweenView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TweenView.this.mousePressed(mouseEvent);
                if (mouseEvent.getButton() == 3) {
                    TweenView.this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TweenView.this.mouseReleased();
            }
        });
    }

    public void recalibrate() {
        Interval interval = new Interval(0.0f, 0.0f);
        Interval interval2 = new Interval(0.0f, 0.0f);
        for (TweenViewPath tweenViewPath : this.paths) {
            Tween tween = tweenViewPath.getTween();
            interval.union(tween.getInterval());
            interval2.union(tween.getRange());
        }
        float f = interval.length();
        interval.extend(interval.from() - 0.1f * f);
        interval.extend(interval.to() + 0.1f * f);
        float f2 = interval2.length();
        interval2.extend(interval2.from() - 0.1f * f2);
        interval2.extend(interval2.to() + 0.1f * f2);
        if (interval.length() == 0.0f || interval2.length() == 0.0f) {
            return;
        }
        this.grid.area(new Rectangle(interval.from(), interval2.from(), interval.length(), interval2.length()));
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.grid.draw(graphics);
        for (TweenViewPath tweenViewPath : this.paths) {
            tweenViewPath.draw(graphics);
        }
        if (this.activePoint != null && this.activePath != null) {
            Vector2f vector2f = this.grid.gridToScreen(this.point(this.activePoint, this.activeType));
            int n = (int)vector2f.x;
            int n2 = (int)vector2f.y;
            this.activePath.getTweenDrawer().drawIndicator(graphics, n, n2, this.activePoint.getType());
            this.activePath.getTweenDrawer().drawLengths(graphics, n, n2, this.activePoint, this.activePath.getTween().getPoints());
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.activePath = null;
        this.activePoint = null;
        for (TweenViewPath tweenViewPath : this.paths) {
            Tween tween = tweenViewPath.getTween();
            for (TweenPoint tweenPoint : tween.getPoints()) {
                switch (tweenPoint.getType()) {
                    case Step: 
                    case Interpolation: {
                        this.activePosition = this.grid.gridToScreen(tweenPoint.getPoint());
                        if (!this.near(this.mouse, this.activePosition, 4.0f)) break;
                        this.activePoint = tweenPoint;
                        this.activeType = Point.Center;
                        break;
                    }
                    case Curve: {
                        this.activePosition = this.grid.gridToScreen(tweenPoint.getPoint());
                        if (this.near(this.mouse, this.activePosition, 4.0f)) {
                            this.activePoint = tweenPoint;
                            this.activeType = Point.Center;
                        }
                        this.activePosition = this.grid.gridToScreen(this.point(tweenPoint, Point.Left));
                        if (this.near(this.mouse, this.activePosition, 4.0f)) {
                            this.activePoint = tweenPoint;
                            this.activeType = Point.Left;
                        }
                        this.activePosition = this.grid.gridToScreen(this.point(tweenPoint, Point.Right));
                        if (!this.near(this.mouse, this.activePosition, 4.0f)) break;
                        this.activePosition = this.point(tweenPoint, Point.Right);
                        this.activePoint = tweenPoint;
                        this.activeType = Point.Right;
                    }
                }
            }
            if (this.activePoint == null) continue;
            if (mouseEvent.getButton() == 2) {
                int n = (this.activePoint.getType().id + 1) % PointType.values().length;
                this.activePoint.setType(PointType.fromId(n));
            }
            this.activePath = tweenViewPath;
            this.control.disable();
            this.repaint();
            return;
        }
    }

    private void moveActivePoint(int n, int n2, boolean bl, boolean bl2) {
        Vector2f vector2f = this.grid.screenToGrid(new Vector2f(n, n2));
        if (bl2) {
            vector2f.x = this.grid.snapHorizontal(vector2f.x);
            vector2f.y = this.grid.snapVertical(vector2f.y);
        }
        switch (this.activeType) {
            case Center: {
                this.activePoint.getPoint().set(vector2f);
                break;
            }
            case Left: {
                if (vector2f.x > this.activePoint.getPoint().x) {
                    vector2f.x = this.activePoint.getPoint().x;
                }
                this.activePoint.getLeft().set(vector2f).subtractLocal(this.activePoint.getPoint());
                if (!bl) break;
                this.activePoint.getRight().set(vector2f).subtractLocal(this.activePoint.getPoint()).multLocal(-1.0f);
                break;
            }
            case Right: {
                if (vector2f.x < this.activePoint.getPoint().x) {
                    vector2f.x = this.activePoint.getPoint().x;
                }
                this.activePoint.getRight().set(vector2f).subtractLocal(this.activePoint.getPoint());
                if (!bl) break;
                this.activePoint.getLeft().set(vector2f).subtractLocal(this.activePoint.getPoint()).multLocal(-1.0f);
            }
        }
    }

    private boolean near(Vector2f vector2f, Vector2f vector2f2, float f) {
        return (vector2f.x - vector2f2.x) * (vector2f.x - vector2f2.x) + (vector2f.y - vector2f2.y) * (vector2f.y - vector2f2.y) <= f * f;
    }

    private Vector2f point(TweenPoint tweenPoint, Point point) {
        switch (point) {
            default: {
                return tweenPoint.getPoint();
            }
            case Left: {
                return tweenPoint.getPoint().add(tweenPoint.getLeft());
            }
            case Right: 
        }
        return tweenPoint.getPoint().add(tweenPoint.getRight());
    }

    private void showPopupMenu(Component component, int n, int n2) {
        this.menuPoint = this.activePoint;
        JPopupMenu jPopupMenu = new JPopupMenu("Actions");
        if (this.menuPoint == null) {
            jPopupMenu.add(this.itemAdd);
        } else {
            jPopupMenu.add(this.itemDelete);
            jPopupMenu.add(this.itemType);
        }
        jPopupMenu.show(component, n, n2);
        this.menuInvocation.x = n;
        this.menuInvocation.y = n2;
    }

    private void mouseReleased() {
        this.activePoint = null;
        this.control.enable();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.addItems.length; ++i) {
            if (!this.addItems[i].equals(actionEvent.getSource())) continue;
            Vector2f vector2f = this.grid.screenToGrid(this.menuInvocation);
            TweenViewPath tweenViewPath = this.paths.get(i);
            tweenViewPath.getTween().addPoint(new TweenPoint(vector2f, PointType.Interpolation));
            this.repaint();
            return;
        }
        if (this.activePath == null) {
            return;
        }
        Tween tween = this.activePath.getTween();
        if (this.itemDelete.equals(actionEvent.getSource())) {
            tween.removePoint(this.menuPoint);
        }
        if (this.itemValue.equals(actionEvent.getSource())) {
            this.menuPoint.setType(PointType.Step);
        }
        if (this.itemInterpolation.equals(actionEvent.getSource())) {
            this.menuPoint.setType(PointType.Interpolation);
        }
        if (this.itemCurve.equals(actionEvent.getSource())) {
            this.menuPoint.setType(PointType.Curve);
        }
        this.repaint();
    }

    private static enum Point {
        Left,
        Center,
        Right;

    }
}

