/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector2f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.material.DistanceFieldMaterial;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.ui.CameraControl;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.CityBuilder;

public class GreetingScene
implements Scene {
    private final CityBuilder cityBuilder;
    private final CameraControl cameraControl;
    private final Parameter<Vector2f> windowParameter;
    private final Parameter<Float> textParameter;

    @Inject
    public GreetingScene(RenderEngine renderEngine, ParameterFactory parameterFactory, AssetManager assetManager, CityBuilder cityBuilder, CameraControl cameraControl) {
        this.cityBuilder = cityBuilder;
        this.cameraControl = cameraControl;
        cameraControl.registerParameters(this, "greeting");
        this.windowParameter = parameterFactory.tween2f(this, "greeting-window-control");
        this.textParameter = parameterFactory.tween1f(this, "greeting-text-control");
    }

    @Override
    public void onInit(GL gL) {
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onPreCalc() {
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getRoadRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTextRoot()));
        this.cameraControl.registerParameters(this, "greeting", interval.from());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
        node.removeChild(this.cityBuilder.getRoadRoot());
        node.removeChild(this.cityBuilder.getTextRoot());
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        Vector2f vector2f = this.windowParameter.get(f2);
        BuildingMaterial buildingMaterial = this.cityBuilder.getBuildingMaterial();
        buildingMaterial.setAlpha(vector2f.x);
        buildingMaterial.setHeight(vector2f.y);
        float f5 = this.textParameter.get(f2).floatValue();
        for (DistanceFieldMaterial distanceFieldMaterial : this.cityBuilder.getMaterials()) {
            distanceFieldMaterial.getForeground().w = f5;
        }
        this.cameraControl.positionCamera(f2);
        this.cityBuilder.update(f2);
    }
}

