/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.camera.OrthographicCamera;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.font.FontSystem;
import tazadum.engine.rendering.layout.NormalizedLayout;
import tazadum.engine.rendering.mesh.TexturedMesh;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.DistanceFieldShader;

public class TextScene
implements Scene {
    private final RenderEngine renderEngine;
    private final DistanceFieldShader distanceFieldShader;
    private final FontSystem fontSystem;
    private final NormalizedLayout layout;
    private final Parameter<Vector2f> positionParameter;
    private final Asset<Font> font;
    private TexturedMesh mesh;
    private TexturedMesh clawMesh;
    private TexturedMesh druttisMesh;
    private TexturedMesh today;
    private final Parameter<Vector2f> clawParameter;
    private final Parameter<Vector2f> druttisParameter;
    private final Parameter<Vector2f> todayParameter;

    @Inject
    public TextScene(RenderEngine renderEngine, AssetManager assetManager, DistanceFieldShader distanceFieldShader, FontSystem fontSystem, ParameterFactory parameterFactory, NormalizedLayout normalizedLayout) {
        this.renderEngine = renderEngine;
        this.distanceFieldShader = distanceFieldShader;
        this.fontSystem = fontSystem;
        this.layout = normalizedLayout;
        this.positionParameter = parameterFactory.tween2f(this, "text");
        this.todayParameter = parameterFactory.tween2f(this, "text-today");
        this.clawParameter = parameterFactory.tween2f(this, "text-claw");
        this.druttisParameter = parameterFactory.tween2f(this, "text-druttis");
        this.font = assetManager.loadFont("resources/font/font.fnt", "resources/font/font.png");
        renderEngine.getCamera().moveTo(new Vector3f(0.0f, 0.0f, -100.0f)).lookAt(Vector3f.UNIT_Y, new Vector3f(0.0f, 0.0f, 0.0f)).update();
    }

    @Override
    public void onPreCalc() {
    }

    @Override
    public void onInit(GL gL) {
        this.mesh = this.fontSystem.createMesh(this.font, "TAZADUM");
        this.today = this.fontSystem.createMesh(this.font, "Today");
        this.clawMesh = this.fontSystem.createMesh(this.font, "klovman");
        this.druttisMesh = this.fontSystem.createMesh(this.font, "druttis");
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        GL2 gL22 = gL2.getGL2();
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        OrthographicCamera orthographicCamera = this.renderEngine.getOrthographicCamera();
        Vector2f vector2f = this.positionParameter.get(f2);
        this.layout.transformLocal(vector2f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setTranslation(new Vector3f(vector2f.x, vector2f.y, 1.0f));
        Matrix4f matrix4f2 = new Matrix4f();
        float f5 = 0.8f * orthographicCamera.getBounds().width / (this.mesh.getBoundingBox().getWidth() + 40.0f);
        matrix4f2.setScale(f5, 1.0f, 0.0f);
        Matrix4f matrix4f3 = new Matrix4f();
        matrix4f3.multLocal(matrix4f);
        matrix4f3.multLocal(matrix4f2);
        this.distanceFieldShader.enable(gL22);
        this.distanceFieldShader.bindForegroundColor(gL22, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.distanceFieldShader.bindBackgroundColor(gL22, Vector4f.ZERO);
        this.distanceFieldShader.bindThreshold(gL22, 0.5f);
        this.distanceFieldShader.bindProjection(gL22, orthographicCamera.getProjection());
        this.distanceFieldShader.bindView(gL22, orthographicCamera.getView());
        this.distanceFieldShader.bindModel(gL22, matrix4f3);
        this.distanceFieldShader.bindTexture0(gL22, this.mesh.getTexture());
        this.distanceFieldShader.bindVertices(gL22, this.mesh.getVertices());
        this.distanceFieldShader.bindTexCoords0(gL22, this.mesh.getTextureChoords());
        gL22.glDepthMask(false);
        this.mesh.draw(gL22);
        matrix4f2.set(Matrix4f.IDENTITY);
        float f6 = 0.8f * orthographicCamera.getBounds().width / (this.mesh.getBoundingBox().getWidth() + 40.0f);
        matrix4f2.setScale(f6, f6 * 0.9f, 0.0f);
        Vector2f vector2f2 = this.todayParameter.get(f2);
        this.layout.transformLocal(vector2f2);
        matrix4f3.set(Matrix4f.IDENTITY);
        matrix4f3.setTranslation(vector2f2.x, vector2f2.y, 1.0f);
        matrix4f3.multLocal(matrix4f2);
        this.distanceFieldShader.bindModel(gL22, matrix4f3);
        this.distanceFieldShader.bindTexture0(gL22, this.today.getTexture());
        this.distanceFieldShader.bindVertices(gL22, this.today.getVertices());
        this.distanceFieldShader.bindTexCoords0(gL22, this.today.getTextureChoords());
        this.today.draw(gL22);
        Vector2f vector2f3 = this.clawParameter.get(f2);
        this.layout.transformLocal(vector2f3);
        matrix4f3.set(Matrix4f.IDENTITY);
        matrix4f3.setTranslation(vector2f3.x, vector2f3.y, 1.0f);
        this.distanceFieldShader.bindModel(gL22, matrix4f3);
        this.distanceFieldShader.bindTexture0(gL22, this.clawMesh.getTexture());
        this.distanceFieldShader.bindVertices(gL22, this.clawMesh.getVertices());
        this.distanceFieldShader.bindTexCoords0(gL22, this.clawMesh.getTextureChoords());
        this.clawMesh.draw(gL22);
        Vector2f vector2f4 = this.druttisParameter.get(f2);
        this.layout.transformLocal(vector2f4);
        matrix4f3.set(Matrix4f.IDENTITY);
        matrix4f3.setTranslation(vector2f4.x, vector2f4.y, 1.0f);
        this.distanceFieldShader.bindModel(gL22, matrix4f3);
        this.distanceFieldShader.bindTexture0(gL22, this.druttisMesh.getTexture());
        this.distanceFieldShader.bindVertices(gL22, this.druttisMesh.getVertices());
        this.distanceFieldShader.bindTexCoords0(gL22, this.druttisMesh.getTextureChoords());
        this.druttisMesh.draw(gL22);
        gL22.glDepthMask(true);
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
    }

    @Override
    public void onStop(Node<MeshNode> node) {
    }
}

