/*
 * Decompiled with CFR 0.152.
 */
package tazmania.shader;

import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.shader.Shader;
import tazadum.engine.rendering.shader.ShaderHelper;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.util.Logger;

public class PostFxShader
implements LifeCycle,
Shader {
    private static final String VERTEX_PROGRAM = "resources/shaders/postfx.vertex.glsl";
    private static final String FRAGMENT_PROGRAM = "resources/shaders/postfx.fragment.glsl";
    private final ResourceManager resourceManager;
    private int vertexShader;
    private int fragmentShader;
    private int program;
    private int locTexture0;
    private int locTexCoord0;
    private int locVertex;
    private int locPixel;
    private int locBlend;
    private int locAlpha;
    private int locRatio;

    @Inject
    public PostFxShader(LifeCycleManager lifeCycleManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        lifeCycleManager.add(this);
    }

    @Override
    public void onInit(GL gL) {
        if (!gL.isGL2()) {
            System.out.println("GL2 not supported");
            return;
        }
        GL2 gL2 = gL.getGL2();
        byte[] byArray = this.resourceManager.load(VERTEX_PROGRAM);
        byte[] byArray2 = this.resourceManager.load(FRAGMENT_PROGRAM);
        this.vertexShader = ShaderHelper.compile(gL2, 35633, new String(byArray));
        this.fragmentShader = ShaderHelper.compile(gL2, 35632, new String(byArray2));
        this.program = gL2.glCreateProgram();
        gL2.glAttachShader(this.program, this.vertexShader);
        gL2.glAttachShader(this.program, this.fragmentShader);
        gL2.glLinkProgram(this.program);
        int[] nArray = new int[1];
        gL2.glGetProgramiv(this.program, 35714, nArray, 0);
        if (nArray[0] != 1) {
            Logger.log("Linking shader failed: %s", ShaderUtil.getProgramInfoLog((GL)gL2, (int)this.program));
            throw new IllegalArgumentException("Could not link program");
        }
        this.locVertex = gL2.glGetAttribLocation(this.program, "a_position");
        this.locTexCoord0 = gL2.glGetAttribLocation(this.program, "a_texCoord0");
        this.locTexture0 = gL2.glGetUniformLocation(this.program, "u_texture0");
        this.locPixel = gL2.glGetUniformLocation(this.program, "u_pixel");
        this.locBlend = gL2.glGetUniformLocation(this.program, "u_blend");
        this.locAlpha = gL2.glGetUniformLocation(this.program, "u_alpha");
        this.locRatio = gL2.glGetUniformLocation(this.program, "u_ratio");
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void enable(GL2 gL2) {
        gL2.glUseProgram(this.program);
    }

    @Override
    public void disable(GL2 gL2) {
        gL2.glUseProgram(0);
    }

    public void bindTexture0(GL2 gL2, int n) {
        gL2.glActiveTexture(33986);
        gL2.glBindTexture(3553, n);
        gL2.glUniform1i(this.locTexture0, 2);
    }

    public void bindVertices(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locVertex);
        gL2.glVertexAttribPointer(this.locVertex, 3, 5126, false, 12, (Buffer)floatBuffer);
    }

    public void bindTexCoords0(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locTexCoord0);
        gL2.glVertexAttribPointer(this.locTexCoord0, 2, 5126, false, 8, (Buffer)floatBuffer);
    }

    public void bindPixelation(GL2 gL2, float f) {
        gL2.glUniform1f(this.locPixel, f);
    }

    public void bindBlend(GL2 gL2, float f) {
        gL2.glUniform1f(this.locBlend, f);
    }

    public void bindAlpha(GL2 gL2, float f) {
        gL2.glUniform1f(this.locAlpha, f);
    }

    public void bindRatio(GL2 gL2, float f) {
        gL2.glUniform1f(this.locRatio, f);
    }
}

