precision mediump float;

uniform sampler2D velocity;
uniform sampler2D position;

uniform float dt;


varying vec2 texCoord0;

void main(void) {
	vec4 v = texture2d(velocity, texCoord0);
	vec4 p = texture2d(position, texCoord0);
	
	vec3 pos = p.xyz + dt * v.xyz;
	float alpha = v.w < 0 ? 0 : p.w;

    gl_FragColor = vec4(pos, alpha);
}