#version 410 core

uniform vec3 cvCenter;
uniform float cvSize;

in vec3 wpos;

layout (location = 0) out vec4 frag_data;

void main()
{
	vec3 pos = wpos * (1.0 / cvSize);
	vec3 fracPos = cvCenter - pos;
	float scale = 1.0 - clamp(length(fracPos) / cvSize, 0.0, 1.0);

	frag_data.xyz = wpos;//(pos - fracPos) * cvSize;
	frag_data.w = scale * cvSize;
}
