#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform float size;

layout (location = 0) in vec4 POSITION;

void main()
{
	vec4 pos = vec4(POSITION.x, POSITION.y, 0.0, 1.0);
	float d = sqrt(dot(POSITION.zw, POSITION.zw));
	gl_PointSize = size + d*d*d*0.5;// + POSITION.z*32.0;
	gl_Position = ModelViewProjectionMatrix * pos;
}
