#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

uniform float time;

layout (location = 0) in vec3 POSITION; //
layout (location = 1) in vec3 NORMAL; // velocity
layout (location = 2) in vec3 COLOR; // force
layout (location = 3) in vec3 TANGENT; // radius, time, decay

out float lit;
out vec3 wpos;

void main()
{
#if 0
	float t = (time - TANGENT.y) / TANGENT.z;
	float k = 1.0 - sin(t*1.571);
	float r = (smoothstep(0.0, 0.001, t) - smoothstep(0.9, 1.0, t)) * TANGENT.x;
	//if ( dt <= 0.001 ) r = 0.0;
	const float speed = 64.0;
	vec3 offset = NORMAL*t*speed;
	offset.y = NORMAL.y*t*speed*k;
	vec3 rnd = sin(offset + POSITION).zxy*k*t;
	vec4 pos = vec4(POSITION + offset + rnd, 1.0);
	wpos = vec3(ModelViewMatrix * pos);
	lit = max(1.0 - (length(wpos) / 64.0), 0.0);
	gl_PointSize = r*lit;
	gl_Position = ModelViewProjectionMatrix * pos;
#else
	vec3 rnd = NORMAL * sin( time*0.5 + length(POSITION)) * 0.25;
	vec4 pos = vec4(POSITION + rnd, 1.0);
	wpos = vec3(ModelViewMatrix * pos);

	float angle = time*1.56 + dot(pos.xyz, vec3(1.0));
	float s = sin(angle);
	float c = cos(angle);
	vec3 n = NormalMatrix * NORMAL;
	n.xz = vec2(n.x*c + n.z*s, -n.x*s + n.z*c);
	float d = 0.5 + 0.5*abs(dot(normalize(n), vec3(0.0, 0.0, 1.0)));
	lit = max(1.0 - (length(wpos) / 128.0), 0.0) * d;
	gl_PointSize = TANGENT.x*lit;
	gl_Position = ModelViewProjectionMatrix * pos;
#endif
}
