uniform vec4 sphereParams; // center.xyz, radius

void PinHeadDisplace(in vec3 origin, out vec4 newPos, out vec3 displaceVector)
{
	vec3 diff = origin - sphereParams.xyz;
	float l = 1.0 - min(length(diff) / sphereParams.w, 1.0);
	diff = normalize(diff)*pow(l, 4.0);
	newPos = vec4(origin + diff, 1.0);
	displaceVector = diff;
}
