#version 410 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer instanceData;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

void main()
{
	vec4 instData = texelFetch(instanceData, gl_InstanceID);

	vec4 pos = vec4(POSITION*instData.w + instData.xyz, 1.0);

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
