;;drawtext -nrb @demo 16777215 0 console 8 0 0 fps: %#
alias dmDrawFrame {
    inc %c
    if ((%% == %$) || ($ticks >= %!)) {
        set %! $calc($ticks + 1000)
        set %# %%
        set %% 0
    }
    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 320 180 @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 320 180
    inc %%
    .timerdmDrawFrame -mht 1 $calc(%$ - ($ticks - %+)) noop $!dmStartDraw( $1 )
}

alias dmStartDraw {
    set %+ %- | $1
}

alias demo_warning {
    if (%c < 1) {
        splay -w $qt(%dm.music)
    }
    var %cnt 0
    var %tot $hget(demo, warning_cnt)
    var %ltot $hget(demo, warning_ltot)
    var %colour $gettok($hget(demo, warning_ctab), $hget(demo, warning_ctab_c), 32)
    while (%cnt < %ltot) {
        drawtext -nr @demo %colour "lucida console" 12 0 $calc(10 + (%cnt * 12)) $left($hget(demo, $+(warning_,%cnt)),$calc(%tot - (%cnt * 41)))
        inc %cnt
    }
    if ($hget(demo, warning_ltot) < 13) {
        if (42 // $hget(demo, warning_cnt)) {
            hinc demo warning_ltot
        }
    }
    if ($hget(demo, warning_ctab_c) > 60) {
        hadd demo warning_ctab_c 0
    }
    hinc demo warning_ctab_c .5
    hinc demo warning_cnt .5
    if ($inwave(%dm.music).pos > 18500) {
        drawrect -nrf @demo 0 0 0 0 320 $hget(demo, warning_fade)
        if ($hget(demo, warning_fade) < 180) {
            hinc demo warning_fade 2
        }
    }
    ;;
    noop $dmDrawFrame(demo_warning)
    if ($inwave(%dm.music).pos > 20000) {
        .signal -n part_select intro
        halt
    }
}

alias demo_intro {
    if ((%c > 100) && ($inwave(%dm.music).pos < 27500)) {
        drawpic -ncst @demo 0 $calc(0 - $hget(demo, intro_pic_xpos)) 0 320 180 $qt($scriptdirimg\square_wave.gif)
        var %fade1 $hget(demo, intro_fade1)
        drawreplace -nr @demo $rgb(255, 0, 255) $rgb(%fade1, %fade1, %fade1)
        if (%fade1 < 255) {
            hinc demo intro_fade1 15
        }
    }
    if ($inwave(%dm.music).pos > 27500) {
        var %scale1 $hget(demo, intro_scale_1)
        var %scale2 $hget(demo, intro_scale_2)
        drawpic -ncst @demo 0 $calc(0 + (%scale1 / 2)) $calc(0 + (%scale2 / 2)) $calc(320 - %scale1) $calc(180 - %scale2) $qt($scriptdirimg\square_wave.gif)
        drawreplace -nr @demo $rgb(255, 0, 255) 16777215
        if (%scale1 < 320) {
            if (%scale2 < 180) {
                hinc demo intro_scale_2 0.5
            }
            hinc demo intro_scale_1 0.85
        }
        drawrot -nc @demo $hget(demo, intro_rot) 0 0 320 180
        hinc demo intro_rot $calc(1 + ($hget(demo, intro_rot) / 160))
    }
    noop $dmDrawFrame(demo_intro)
    if ($inwave(%dm.music).pos > 34300) {
        .signal -n part_select filler_01
        halt
    }
}

alias demo_filler_01 {
    var %anim.x $hget(demo, filler_01_anim_x)
    if (%anim.x < 320) {
        if (%anim.x > -98) {
            var %frame $hget(demo, filler_01_anim_fc)
            drawpic -nc @demo %anim.x 95 $qt($+($scriptdirimg\twi_walkcycle\,%frame,.png))
            if (6 // %c) {
                hinc demo filler_01_anim_fc
            }
            if (%frame >= 16) {
                hadd demo filler_01_anim_fc 1
            }
        }
        else {
            var %fadeout 1
        }
    }
    hdec demo filler_01_anim_x 0.6
    ;; raster background
    var %cnt 16
    var %tab $hget(demo, filler_01_ctab)
    var %tab.c $hget(demo, filler_01_ctab_offset)
    var %tot $calc($hget(demo, filler_01_logo_fade) + 15)
    while (%cnt <= %tot) {
        drawline -nr @demo $gettok(%tab, %tab.c, 32) 1 0 %cnt 320 %cnt
        if (%tab.c > 27) {
            var %tab.c 0
        }
        inc %tab.c 3
        inc %cnt 2
    }
    if ($hget(demo, filler_01_ctab_offset) < 1) {
        hadd demo filler_01_ctab_offset 28
    }
    hdec demo filler_01_ctab_offset
    ;; techtech logo
    if (%fadeout != 1) {
        var %i 1
        var %tot $hget(demo, filler_01_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot < 65) {
            hinc demo filler_01_logo_fade
        }
    }
    else {
        var %i 1
        var %tot $hget(demo, filler_01_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot > 0) {
            hdec demo filler_01_logo_fade .5
        }
    }
    ;;
    drawline -nri @demo 0 1 0 85 $calc(%tot * 5) 85
    var %text $hget(demo, filler_01_text)
    var %tot $len(%text)
    var %cnt $hget(demo, filler_01_text_offset)
    var %xmain $hget(demo, filler_01_text_x)
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 40))
        if (%xpos < 320) {
            if (%xpos > -64) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawpic -nct @demo 16711935 %xpos 100 $qt($+($scriptdirimg\chr2\,%chr,.png))
                }
            }
            else {
                hinc demo filler_01_text_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo filler_01_text_x 4
    noop $dmDrawFrame(demo_filler_01)
    if ($inwave(%dm.music).pos > 48000) {
        .signal -n part_select 01
        halt
    }
}

;; rasterbars
alias demo_01 {
    ;; ugly code I ripped from an unfinished 2k, sorry :(
    var %bcount $hget(demo, part_01_barcount)
    var %t 80,112,144,176,208,240,208,176,144,112,80
    var %a $!rgb(%k,0,0) $!rgb(%k,0,%k) $!rgb(0,0,%k) $!rgb(0,%k,%k) $!rgb(0,%k,0) $!rgb(%k,%k,0) $!rgb(%k,%k,%k) $!rgb(%k,%k,0) $!rgb(0,%k,0) $!rgb(0,%k,%k) $!rgb(0,0,%k) $!rgb(%k,0,%k) $!rgb(%k,0,0)
    var %b 1
    while (%b <= %bcount) {
        var %d $gettok(%a, %b, 32)
        var %y $calc(($cos($calc((%c * 2) + (%b * 16))).deg * (($sin($calc(%c / 2)).deg * 64) + 8)) + 80)
        var %e 1
        while (%e <= 12) {
            var %k $gettok(%t, %e, 44)
            var %f $calc(%y + %e)
            drawline -nr @demo $(%d,2) 2 -4 %f 320 %f
            inc %e 2
        }
        inc %b
    }
    if ($inwave(%dm.music).pos > 58300) {
        if (%bcount > 0) {
            hdec demo part_01_barcount 0.075
        }
        if ($hget(demo, part_01_pic_x) > -128) {
            hdec demo part_01_pic_x 1
        }
    }
    else {
        if (%bcount < 16) {
            hinc demo part_01_barcount 0.05
        }
        if ($hget(demo, part_01_pic_x) > 0) {
            hdec demo part_01_pic_x 1
        }
    }
    drawpic -ntc @demo 16711935 $calc($hget(demo, part_01_pic_x) + 5) 21 $qt($scriptdirimg\twilight_amiga.png)
    noop $dmDrawFrame(demo_01)
    if ($inwave(%dm.music).pos > 61722) {
        .signal -n part_select filler_02
        halt
    }
}

alias demo_filler_02 {
    var %pic
    var %anim.x $hget(demo, filler_02_anim_x)
    if (%anim.x < 320) {
        if (%anim.x > -98) {
            var %frame $hget(demo, filler_02_anim_fc)
            drawpic -nc @demo %anim.x 95 $qt($+($scriptdirimg\dash2\,%frame,.png))
            if (6 // %c) {
                hinc demo filler_02_anim_fc
            }
            if (%frame >= 15) {
                hadd demo filler_02_anim_fc 1
            }
        }
        else {
            var %fadeout 1
        }

    }
    hdec demo filler_02_anim_x 0.7
    ;; raster background
    var %cnt 16
    var %tab $hget(demo, filler_02_ctab)
    var %tab.c $hget(demo, filler_02_ctab_offset)
    var %tot $calc($hget(demo, filler_02_logo_fade) + 15)
    while (%cnt <= %tot) {
        drawline -nr @demo $gettok(%tab, %tab.c, 32) 1 0 %cnt 320 %cnt
        if (%tab.c > 27) {
            var %tab.c 0
        }
        inc %tab.c 3
        inc %cnt 2
    }
    if ($hget(demo, filler_02_ctab_offset) < 1) {
        hadd demo filler_02_ctab_offset 28
    }
    hdec demo filler_02_ctab_offset
    ;; techtech logo
    if (%fadeout != 1) {
        var %i 1
        var %tot $hget(demo, filler_02_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot < 65) {
            hinc demo filler_02_logo_fade
        }
    }
    else {
        var %i 1
        var %tot $hget(demo, filler_02_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot > 0) {
            hdec demo filler_02_logo_fade .5
        }
    }
    ;;
    drawline -nri @demo 0 1 0 85 $calc(%tot * 5) 85
    var %text $hget(demo, filler_02_text)
    var %tot $len(%text)
    var %cnt $hget(demo, filler_02_text_offset)
    var %xmain $hget(demo, filler_02_text_x)
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 40))
        if (%xpos < 320) {
            if (%xpos > -64) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawpic -nct @demo 16711935 %xpos 100 $qt($+($scriptdirimg\chr2\,%chr,.png))
                }
            }
            else {
                hinc demo filler_02_text_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo filler_02_text_x 5.5
    if ($inwave(%dm.music).pos > 73700) {
        .signal -n part_select 03
        halt
    }
    noop $dmDrawFrame(demo_filler_02)
}

;; twister
alias demo_03 {
    var %sin $calc($sin($calc(%c * 2)).deg * 2)
    var %y -32
    while (%y < 180) {
        var %w $calc($sin($calc((%c * %sin) + (%y * 16))).deg * 22)
        drawpic -ncs @demo $calc(($cos($calc((%c * %sin) + (%y * 16))).deg * 64) + 90) %y %w $iif(%w < 0, 4, 5) $qt($+($scriptdirimg\tex3,$iif(%w < 0,b),.gif))
        inc %y 5
    }
    if ($inwave(%dm.music).pos < 75500) {
        drawrect -nrf @demo 0 0 0 0 160 180
    }
    if ($inwave(%dm.music).pos > 85700) {
        hinc demo part_03_pic_fade2 0.8
        drawrect -nrf @demo 0 0 0 $calc(180 - $hget(demo, part_03_pic_fade2)) 160 180
    }
    drawpic -nc @demo $calc(170 + $hget(demo, part_03_pic_fade1)) $calc(20 + $hget(demo, part_03_pic_fade2)) $qt($scriptdirimg\rdnew.png)
    if ($hget(demo, part_03_pic_fade1) > 0) {
        hdec demo part_03_pic_fade1 2
    }
    noop $dmDrawFrame(demo_03)
    if ($inwave(%dm.music).pos > 89200) {
        .signal -n part_select 04
        halt
    }
}

alias demo_04 {
    var %cnt 1
    var %tot $hget(demo, part_04_bobfade)
    while (%cnt <= %tot) {
        var %x $calc(($cos($calc((%c * 4.1) + (%cnt * 4))).deg * 64) + 160))
        var %y $calc(($sin($calc((%c * 3.3) + (%cnt * 4))).deg * 64) + 90)
        var %k $calc((%cnt * 8) - 8)
        drawdot -nr @demo $rgb(%k, 0, 0)  8 $calc(%x - 160) $calc(%y - 20)
        drawdot -nr @demo $rgb(%k, 0, %k) 8 $calc(%x - 80)  $calc(%y - 10)
        drawdot -nr @demo $rgb(0, 0, %k)  8 %x              %y
        drawdot -nr @demo $rgb(0, %k, %k) 8 $calc(%x + 80)  $calc(%y + 10)
        drawdot -nr @demo $rgb(0, %k, 0)  8 $calc(%x + 160) $calc(%y + 20)
        inc %cnt
    }
    if ($inwave(%dm.music).pos > 99500) {
        if (%tot > 0) {
            hdec demo part_04_bobfade 0.2
        }
    }
    else {
        if (%tot < 32) {
            hinc demo part_04_bobfade 0.5
        }
    }
    drawpic -nct @demo 16711935 155 $calc(0 + $hget(demo, part_04_pic_y)) $qt($scriptdirimg\applejack_ciderbarrel.png)
    if ($hget(demo, part_04_pic_y) > -180) {
        hdec demo part_04_pic_y 0.44
    }
    noop $dmDrawFrame(demo_04)
    if ($inwave(%dm.music).pos > 102800) {
        .signal -n part_select 02
        halt
    }
}

;; flipscroll
alias demo_02 {
    var %text $hget(demo, part_02_txt)
    var %xmain $hget(demo, part_02_txt_x)
    var %cnt $hget(demo, part_02_txt_offset)
    var %tot $len(%text)
    while (%cnt <= %tot) {
        var %x $calc(%xmain + (%cnt * 16))
        if (%x < 320) {
            if (%x > -15) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawpic -ncs @demo %x $calc(($cos($calc(((%c * 2) + (%cnt * 8)) + 90)).deg * 11) + ($cos($calc((%c * 2) + (%cnt * 16))).deg * 24) + 90) 16 $calc($sin($calc((%c * 2) + (%cnt * 16))).deg * 22) $qt($+($scriptdirimg\chr3\,%chr,.gif))
                }
            }
            else {
                hinc demo part_02_txt_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo part_02_txt_x 3.5

    ;;
    var %x $hget(demo, part_02_picfade)
    if ($inwave(%dm.music).pos > 126000) {
        hdec demo part_02_picfade
    }
    else {
        if (%x < 0) {
            hinc demo part_02_picfade 0.5
        }
    }
    drawpic -nct @demo 16711935 %x 55 $qt($scriptdirimg\fluttershy-sharp.png)
    noop $dmDrawFrame(demo_02)
    if ($inwave(%dm.music).pos > 130000) {
        .signal -n part_select filler_03
        halt
    }
}

alias demo_filler_03 {
    var %pic
    var %anim.x $hget(demo, filler_03_anim_x)
    if (%anim.x < 320) {
        if (%anim.x > -130) {
            var %frame $hget(demo, filler_03_anim_fc)
            drawpic -nc @demo %anim.x 90 $qt($+($scriptdirimg\pinkie3\,%frame,.png))
            if (6 // %c) {
                hinc demo filler_03_anim_fc
            }
            if (%frame >= 12) {
                hadd demo filler_03_anim_fc 1
            }
        }
        else {
            var %fadeout 1
        }

    }
    hdec demo filler_03_anim_x 0.6
    ;; raster background
    var %cnt 16
    var %tab $hget(demo, filler_03_ctab)
    var %tab.c $hget(demo, filler_03_ctab_offset)
    var %tot $calc($hget(demo, filler_03_logo_fade) + 15)
    while (%cnt <= %tot) {
        drawline -nr @demo $gettok(%tab, %tab.c, 32) 1 0 %cnt 320 %cnt
        if (%tab.c > 27) {
            var %tab.c 0
        }
        inc %tab.c 3
        inc %cnt 2
    }
    if ($hget(demo, filler_03_ctab_offset) < 1) {
        hadd demo filler_03_ctab_offset 28
    }
    hdec demo filler_03_ctab_offset
    ;; techtech logo
    if (%fadeout != 1) {
        var %i 1
        var %tot $hget(demo, filler_03_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot < 65) {
            hinc demo filler_03_logo_fade
        }
    }
    else {
        var %i 1
        var %tot $hget(demo, filler_03_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot > 0) {
            hdec demo filler_03_logo_fade .5
        }
    }
    ;;
    drawline -nri @demo 0 1 0 85 $calc(%tot * 5) 85
    var %text $hget(demo, filler_03_text)
    var %tot $len(%text)
    var %cnt $hget(demo, filler_03_text_offset)
    var %xmain $hget(demo, filler_03_text_x)
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 40))
        if (%xpos < 320) {
            if (%xpos > -64) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawpic -nct @demo 16711935 %xpos 100 $qt($+($scriptdirimg\chr2\,%chr,.png))
                }
            }
            else {
                hinc demo filler_03_text_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo filler_03_text_x 5.5
    noop $dmDrawFrame(demo_filler_03)
    if ($inwave(%dm.music).pos > 144000) {
        .signal -n part_select 08
        halt
    }
}

;; at least 20% more rotozooming ponies in 50fps flat.
alias demo_08 {
    clear @demo.3
    var %cos     $calc((($sin($calc((%c / 4) + 45)  ).deg ^ 4) * 400) + 50)
    var %x.start $calc((($sin($calc(%c / 2.7)).deg ^ 5) * 128) - 128)
    var %y       $calc((($sin($calc(%c / 2.4)).deg ^ 3) * 128) - 128)
    while (%y < 200) {
        var %x %x.start
        while (%x < 200) {
            drawpic -cs @demo.3 %x %y %cos %cos $qt($scriptdirimg\somuchcutiemarks2.png)
            inc %x %cos
        }
        inc %y %cos
    }
    if ($inwave(%dm.music).pos > 157700) {
        var %c2 $hget(demo, part_08_rot_c)
        drawrot -cn @demo.3 $calc((($cos($calc(%c2 / 8)).deg * 512) * 4) + 925) 0 0 200 200
        ;drawrot -cn @demo.3 $calc(($cos($calc(%c2 / 4)).deg * 512) + 940) 0 0 200 200
        hinc demo part_08_rot_c
    }
    drawcopy -n @demo.3 22.5 45 160 90 @demo 0 0 320 180
    ;; fadein
    var %dot $hget(demo, part_08_fade_dotsize)
    if (%dot < 400) {
        clear @demo.6
        drawrect -efr @demo.6 16711935 0 $calc(160 - (%dot / 2)) $calc(90 - (%dot / 2)) %dot %dot
        drawrect -er @demo.6 16711935 5  $calc(150 - (%dot / 2)) $calc(80 - (%dot / 2)) $calc(%dot + 20) $calc(%dot + 20)
        drawcopy -nt @demo.6 16711935 0 0 320 180 @demo 0 0 320 180
        hinc demo part_08_fade_dotsize
    }
    ;; fade in next part, and already include the overlay gfx
    ;; maybe this could make for a nicer, smoother transition
    if ($inwave(%dm.music).pos > 183500) {
        drawrect -nrf @demo 0 0 0 0 $hget(demo, part_08_fadeout) 180
        if ($hget(demo, part_08_fadeout) < 320) {
            hinc demo part_08_fadeout 6
        }
        drawpic -nct @demo 16711935 $hget(demo, part_05_pic_x) 25 $qt($scriptdirimg\pinkie_cider-sharp.png)
        if ($hget(demo, part_05_pic_x) > 8) {
            hdec demo part_05_pic_x 4
        }
    }
    noop $dmDrawFrame(demo_08)
    if ($inwave(%dm.music).pos > 185100) {
        .signal -n part_select 05
        halt
    }
}

alias demo_05 {
    drawrect -nrf @demo 8421504 0 0 0 320 180
    var %cnt 1
    var %fade $hget(demo, part_05_fadeout)
    if ($inwave(%dm.music).pos < 198000) {
        var %x1 $calc(($cos($calc(%c * 3.7)).deg * 48) + 180)
        var %y1 $calc(($cos($calc(%c * 2.3)).deg * 48) + 90)
        var %x2 $calc(($sin($calc(%c * 1.9)).deg * 48) + 180)
        var %y2 $calc(($sin($calc(%c * 3.2)).deg * 48) + 90)
    }
    else {
        var %x1 $calc(($cos($calc(%c * 3.7)).deg * 48) + 180)
        var %y1 $calc((($cos($calc(%c * 2.3)).deg * 48) + 90) - %fade)
        var %x2 $calc(($sin($calc(%c * 1.9)).deg * 48) + 180)
        var %y2 $calc((($sin($calc(%c * 3.2)).deg * 48) + 90) - %fade)
        hinc demo part_05_fadeout 3.5
    }
    var %tot $hget(demo, part_05_moire_c)
    while (%cnt <= %tot) {
        drawdot -nri @demo 4210752 $calc(%cnt * 10) %x1 %y1 %x2 %y2
        inc %cnt
    }
    if (%tot < 32) {
        hinc demo part_05_moire_c 0.5
    }
    if ($inwave(%dm.music).pos > 198000) {
        drawrect -nrf @demo 0 0 0 $calc(180 - %fade) 320 %fade
    }
    drawpic -nct @demo 16711935 $hget(demo, part_05_pic_x) $calc(25 + %fade) $qt($scriptdirimg\pinkie_cider-sharp.png)
    if ($hget(demo, part_05_pic_x) > 8) {
        hdec demo part_05_pic_x $calc($cos(%c).deg * 8)
    }
    noop $dmDrawFrame(demo_05)
    if ($inwave(%dm.music).pos > 198880) {
        .signal -n part_select 06
        halt
    }
}

alias demo_06 {
    var %sin $calc($cos($calc(%c * 8)).deg * 8)
    drawdot -r @demo.1 $rand(0, 16777215) $calc(%sin + 8) $calc((%sin * 8) + 160) $calc((%sin * 11.5) + 160)
    drawrot -c @demo.1 $calc($cos(%c).deg / 128)
    drawrot -c @demo.1 $calc($cos($calc(%c - 90)).deg * 4)
    drawcopy -n @demo.1 0 70 320 180 @demo 0 0 320 180
    var %fade $hget(demo, part_06_pic_fade)
    drawpic -ntc @demo 16711935 0 20 0 0 143 %fade $qt($scriptdirimg\lyra.png)
    drawpic -ntsc @demo 16711935 0 $calc(20 + %fade) 143 $calc(159 - %fade) 0 %fade 143 1 $qt($scriptdirimg\lyra.png)
    if (%fade < 160) {
        hinc demo part_06_pic_fade
    }
    if ($inwave(%dm.music).pos > 210000) {
        var %y1 $gettok($hget(demo, part_06_fadetab), $hget(demo, part_06_fadetab_c), 44)
        drawline -nr @demo.8 0 1 0 %y1 320 %y1
        drawcopy -nt @demo.8 16711935 0 0 320 180 @demo 0 0 320 180
        if ($hget(demo, part_06_fadetab_c) < 180) {
            hinc demo part_06_fadetab_c
        }
    }
    noop $dmDrawFrame(demo_06)
    if ($inwave(%dm.music).pos > 212500) {
        .signal -n part_select 10
        halt
    }
}

alias demo_10 {
    var %size $hget(demo, part_10_zoomsquare_size)
    if ($hget(demo, part_10_picfadetab_y_c) < 13) {
        var %x $calc($gettok($hget(demo, part_10_picfadetab_x), $hget(demo, part_10_picfadetab_x_c), 32) * 2)
        var %y $calc($gettok($hget(demo, part_10_picfadetab_y), $hget(demo, part_10_picfadetab_y_c), 32) * 2)
        drawpic -nr @demo.4 %x %y %x %y 32 32 $qt($scriptdirimg\groupshot.png)
        if ($hget(demo, part_10_picfadetab_x_c) == 20) {
            hinc demo part_10_picfadetab_y_c
        }
        if ($hget(demo, part_10_picfadetab_x_c) == 40) {
            hadd demo part_10_picfadetab_x_c 0
            hinc demo part_10_picfadetab_y_c
        }
        hinc demo part_10_picfadetab_x_c
    }
    else {
        if (%size < 64) {
            hinc demo part_10_zoomsquare_size
        }
        drawpic -nr @demo.4 0 0 $qt($scriptdirimg\groupshot.png)
    }
    drawcopy -n @demo.4 0 0 640 360 @demo 0 0 320 180
    ;; zoomsquare
    var %x $calc(($sin($calc(%c * .7)).deg * 130) + 150)
    var %y $calc(($sin($calc(%c * .5)).deg * 60) + 80)
    drawcopy -n @demo.4 $calc(%x * 2) $calc(%y * 2) %size 64 @demo $calc(%x - 20) $calc(%y - 20) %size 64
    drawrect -nr @demo 0 1 $calc(%x - 20) $calc(%y - 20) %size 64
    var %x $calc(($cos($calc((%c + 90) * .7)).deg * 130) + 150)
    var %y $calc(($cos($calc((%c + 90) * .5)).deg * 60) + 80)
    drawcopy -n @demo.4 $calc(%x * 2) $calc(%y * 2) %size 64 @demo $calc(%x - 20) $calc(%y - 20) %size 64
    drawrect -nr @demo 0 1 $calc(%x - 20) $calc(%y - 20) %size 64
    if ($inwave(%dm.music).pos > 236000) {
        drawrect -nrf @demo 0 0 0 0 320 $hget(demo, part_10_fadeout)
        hinc demo part_10_fadeout
    }
    noop $dmDrawFrame(demo_10)
    if ($inwave(%dm.music).pos > 240000) {
        .signal -n part_select filler_04
        halt
    }
}

alias demo_filler_04 {
    var %anim.x $hget(demo, filler_04_anim_x)
    if (%anim.x < 320) {
        if (%anim.x > -40) {
            var %frame $hget(demo, filler_04_anim_fc)
            drawpic -nc @demo %anim.x 100 $qt($+($scriptdirimg\spike\,%frame,.png))
            if (5 // %c) {
                hinc demo filler_04_anim_fc
            }
            if (%frame >= 12) {
                hadd demo filler_04_anim_fc 1
            }
        }
        else {
            var %fadeout 1
        }
    }
    hdec demo filler_04_anim_x 0.27
    ;; raster background
    var %cnt 16
    var %tab $hget(demo, filler_04_ctab)
    var %tab.c $hget(demo, filler_04_ctab_offset)
    var %tot $calc($hget(demo, filler_04_logo_fade) + 15)
    while (%cnt <= %tot) {
        drawline -nr @demo $gettok(%tab, %tab.c, 32) 1 0 %cnt 320 %cnt
        if (%tab.c > 27) {
            var %tab.c 0
        }
        inc %tab.c 3
        inc %cnt 2
    }
    if ($hget(demo, filler_04_ctab_offset) < 1) {
        hadd demo filler_04_ctab_offset 28
    }
    hdec demo filler_04_ctab_offset
    ;; techtech logo
    if (%fadeout != 1) {
        var %i 1
        var %tot $hget(demo, filler_04_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot < 65) {
            hinc demo filler_04_logo_fade
        }
    }
    else {
        var %i 1
        var %tot $hget(demo, filler_04_logo_fade)
        while (%i <= %tot) {
            drawpic -ncst @demo 16711935 $calc(($sin($calc((%c * 4) + (%i * 2))).deg * 32) - 40) $calc(%i + 15) 400 1 0 %i 400 1  $qt($scriptdirimg\dss-logo-3.gif)
            inc %i 2
        }
        if (%tot > 0) {
            hdec demo filler_04_logo_fade .5
        }
    }
    ;;
    drawline -nri @demo 0 1 0 85 $calc(%tot * 5) 85
    var %text $hget(demo, filler_04_text)
    var %tot $len(%text)
    var %cnt $hget(demo, filler_04_text_offset)
    var %xmain $hget(demo, filler_04_text_x)
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 40))
        if (%xpos < 320) {
            if (%xpos > -64) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawpic -nct @demo 16711935 %xpos 100 $qt($+($scriptdirimg\chr2\,%chr,.png))
                }
            }
            else {
                hinc demo filler_04_text_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo filler_04_text_x 3.7
    noop $dmDrawFrame(demo_filler_04)
    if ($inwave(%dm.music).pos > 264000) {
        .signal -n part_select 12
        halt
    }
}


;; here be dragons... literally.
alias demo_12_pre {
    var %framecount $hget(demo, part_12_precalc_count)
    ;; -- precalc shit follows here --
    var %c2 = %framecount * 2
    var %ctab 255 16711935 16711680 16776960 65535 16777215 65535 16776960 16711680 16711935 255
    drawrect -nrf @demo.5 0 0 0 0 155 95
    var %x 0
    while (%x < 155) {
        var %cos $calc($sin($calc((%x * 2) + %c)).deg * $sin(%c2).deg * 192)
        var %y 0
        while (%y < 95) {
            drawdot -r @demo.5 $gettok(%ctab, $calc((%cos + $sin($calc((%y * 2) + %c)).deg * $cos(%c2).deg * 128) / 32), 32) 3 %x %y
            inc %y 4
        }
        inc %x 4
    }
    drawsave -b4 @demo.5 $qt($+($scriptdirimg\plasma\,%framecount,.bmp))
    hinc demo part_12_precalc_count
}

alias demo_12_test {
    ;var %framecount $hget(demo, part_12_precalc_count)
    ;var %c2 = %framecount * 2

    var %c2 %c
    var %ctab 255 16711935 16711680 16776960 65535 16777215 65535 16776960 16711680 16711935 255
    drawrect -nrf @demo.5 0 0 0 0 155 95
    var %x 0
    while (%x < 155) {
        var %cos $calc($sin($calc((%x * 3) + %c)).deg * $sin(%c2).deg * 192)
        var %y 0
        while (%y < 95) {
            drawdot -r @demo.5 $gettok(%ctab, $calc((%cos + $sin($calc((%y * 3) + %c)).deg * $cos(%c2).deg * 128) / 32), 32) 2 %x %y
            inc %y 3
        }
        inc %x 3
    }
    drawcopy -n @demo.5 0 0 320 180 @demo 0 0 320 180


    noop $dmDrawFrame(demo_12_test)
}

alias demo_12 {
    var %xpos $hget(demo, part_12_scrollout)

    if ($inwave(%dm.music).pos > 267500) {
        if ($hget(demo, part_12_plasma_c) == 359) {
            hadd demo part_12_plasma_c -1
        }
        hinc demo part_12_plasma_c
        drawpic -nc @demo $calc(120 + %xpos) 32 0 0 155 95 $qt($+($scriptdirimg\plasma\,$hget(demo, part_12_plasma_c),.bmp))
    }
    ;;
    var %picfade $hget(demo, part_12_picfade)
    drawpic -ntc @demo 16711935 $calc(%picfade + %xpos) 0 $qt($scriptdirimg\spike.gif)
    if (%picfade < 24) {
        hinc demo part_12_picfade 3
    }
    if ($inwave(%dm.music).pos > 277700) {
        hinc demo part_12_scrollout 1.25
    }
    noop $dmDrawFrame(demo_12)
    if ($inwave(%dm.music).pos > 281200) {
        signal -n part_select 17
        halt
    }
}

;; (angle, x, y, z)    // angle in radians
alias rotate {
    var %t_x %c_x
    var %t_y %c_y
    var %t_z %c_z
    var %cos_i $cos($1)
    var %sin_i $sin($1)
    set %c_x $calc(%t_x * (%cos_i + $2 * $2 * (1 - %cos_i)) + %t_y * ($2 * $3 * (1 - %cos_i) - $4 * %sin_i) + %t_z * ($2 * $4 * (1 - %cos_i) + $3 * %sin_i))
    set %c_y $calc(%t_x * ($3 * $2 * (1 - %cos_i) + $4 * %sin_i) + %t_y * (%cos_i + $3 * $3 * (1 - %cos_i)) + %t_z * ($3 * $4 * (1 - %cos_i) - $2 * %sin_i))
    ;;set %c_z $calc(%t_x * ($4 * $2 * (1 - %cos_i) - $3 * %sin_i) + %t_y * ($4 * $3 * (1 - %cos_i) + $2 * %sin_i) + %t_z * (%cos_i + $4 * $4 * (1 - %cos_i)))
    ;;echo -s %c_x
}

alias foo {
    var %rx $sin(%c1 / 500.0)
    var %ry $cos(%c1 / 300.0)
    var %rz 0
    var %scale 30

    var %xpos $calc( 2 + ( 1.5 * %rx1 ))
    var %ypos $calc( 2 + ( 1.5 * %ry1 ))

    ;; left
    set %c_x $hget(demo, part_17_v0_x)
    set %c_y $hget(demo, part_17_v0_y)
    set %c_z $hget(demo, part_17_v0_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v0_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v0_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v0_z_r $calc((%c_z ) * %scale)

    ;; front
    set %c_x $hget(demo, part_17_v1_x)
    set %c_y $hget(demo, part_17_v1_y)
    set %c_z $hget(demo, part_17_v1_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v1_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v1_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v1_z_r $calc((%c_z + 5) * %scale)

    ;; right
    set %c_x $hget(demo, part_17_v2_x)
    set %c_y $hget(demo, part_17_v2_y)
    set %c_z $hget(demo, part_17_v2_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v2_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v2_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v2_z_r $calc((%c_z + 5) * %scale)

    ;;back
    set %c_x $hget(demo, part_17_v3_x)
    set %c_y $hget(demo, part_17_v3_y)
    set %c_z $hget(demo, part_17_v3_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v3_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v3_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v3_z_r $calc((%c_z + 5) * %scale)

    ;;top
    set %c_x $hget(demo, part_17_v4_x)
    set %c_y $hget(demo, part_17_v4_y)
    set %c_z $hget(demo, part_17_v4_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v4_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v4_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v4_z_r $calc((%c_z + 5) * %scale)

    ;;bottom
    set %c_x $hget(demo, part_17_v5_x)
    set %c_y $hget(demo, part_17_v5_y)
    set %c_z $hget(demo, part_17_v5_z)
    rotate %c1 %rx %ry 0
    hadd demo part_17_v5_x_r $calc((%c_x + %xpos) * %scale)
    hadd demo part_17_v5_y_r $calc((%c_y + %ypos) * %scale)
    hadd demo part_17_v5_z_r $calc((%c_z + 5) * %scale)
}

;; drawline -nr <colour> <size> <x y> <x y>
alias demo_17 {
    set %c1 $calc(%c / 50.0)

    set %rx1 1 + $sin(%c1 )
    set %ry1 1 + $cos($calc(%c / 15.0))
    foo
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r)

    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)

    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo $rgb(255,255,255) 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)

    set %c1 $calc(%c / 50.0 + 2)

    set %rx1 1 + $cos(%c1 )
    set %ry1 1 + $sin($calc((%c + 30) / 15.0))
    foo
    drawline -r @demo 16716820 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r)

    drawline -r @demo 16716820 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)

    drawline -r @demo 16716820 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16716820 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)

    set %c1 $calc(%c / 50.0 + 3)
    set %rx1 1 + $sin(%c1 )
    set %ry1 1 + $cos($calc((%c + 20) / 15.0))
    foo
    drawline -r @demo 16776980 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r)

    drawline -r @demo 16776980 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)

    drawline -r @demo 16776980 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 16776980 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)

    set %c1 $calc(%c / 50.0 + 1)
    set %rx1 1 + $cos(%c1 )
    set %ry1 1 + $sin($calc((%c + 10) / 15.0))
    foo
    drawline -r @demo 65280 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r)

    drawline -r @demo 65280 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v4_x_r) $hget(demo, part_17_v4_y_r)

    drawline -r @demo 65280 1 $hget(demo, part_17_v0_x_r) $hget(demo, part_17_v0_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v1_x_r) $hget(demo, part_17_v1_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v2_x_r) $hget(demo, part_17_v2_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)
    drawline -r @demo 65280 1 $hget(demo, part_17_v3_x_r) $hget(demo, part_17_v3_y_r) $hget(demo, part_17_v5_x_r) $hget(demo, part_17_v5_y_r)

    drawpic -ntc @demo 16711935 160 10 $qt($scriptdirimg\rd_wall.png)

    var %fadein $hget(demo, part_17_fadein)
    if (%fadein > -160) {
        hdec demo part_17_fadein
        drawrect -nrf @demo 0 0 %fadein 0 160 180
    }
    if ($inwave(%dm.music).pos > 291500) {
        hinc demo part_17_fadeout 2
        drawrect -nrf @demo 8421504 0 0 0 $hget(demo, part_17_fadeout) 180
    }
    noop $dmDrawFrame(demo_17)
    if ($inwave(%dm.music).pos > 295000) {
        signal -n part_select 15b
        halt
    }
}

alias demo_15b {
    drawrect -nrf @demo 8421504 0 0 0 320 180
    var %picfade $hget(demo, part_15_pic_fade)
    drawpic -ncst @demo 0 $calc(180 - %picfade) 0 320 %picfade 0 0 320 %picfade $qt($scriptdirimg\square_wave.gif)
    if (%picfade < 180) {
        hinc demo part_15_pic_fade
    }
    drawreplace -nr @demo $rgb(255, 0, 255) $rgb(192,192,192)
    ;;-----
    var %font Impact
    var %size 20
    var %cnt 1
    var %tot $hget(demo_endscroll, 0).item
    var %y $hget(demo, part_15_scroll_y)
    while (%cnt <= %tot) {
        var %ypos $calc(%y + (%cnt * 24))
        var %text $hget(demo_endscroll, %cnt)
        if (%text != $null) {
            if (%ypos > -28) {
                if (%ypos < 370) {
                    var %xpos $calc(160 - ($width(%text, %font, %size) / 2))
                    drawtext -nr @demo 0 %font %size $calc(%xpos + 2) $calc(%ypos + 2) %text
                    drawtext -nr @demo 16777215 %font %size %xpos %ypos %text
                }
                else {
                    break
                }
            }
            else {
                hadd demo_endscroll %cnt
            }
        }
        inc %cnt
    }
    if ($hget(demo, part_15_scroll_y) > -1010) {
        hdec demo part_15_scroll_y .5
    }
    noop $dmDrawframe(demo_15b)
}


;; endscroller
alias demo_15 {
    drawrect -nrf @demo 8421504 0 0 0 320 180
    var %picfade $hget(demo, part_15_pic_fade)
    drawpic -ncst @demo 0 $calc(180 - %picfade) 0 320 %picfade 0 0 320 %picfade $qt($scriptdirimg\square_wave.gif)
    if (%picfade < 180) {
        hinc demo part_15_pic_fade
    }
    drawreplace -nr @demo $rgb(255, 0, 255) $rgb(192,192,192)
    ;;-----
    drawrect -nrf @demo.7 8421504 0 0 0 400 400
    var %font Impact
    var %size 20
    var %cnt 1
    var %tot $hget(demo_endscroll, 0).item
    var %y $hget(demo, part_15_scroll_y)
    while (%cnt <= %tot) {
        var %ypos $calc(%y + (%cnt * 24))
        var %text $hget(demo_endscroll, %cnt)
        if (%text != $null) {
            if (%ypos > -28) {
                if (%ypos < 370) {
                    var %xpos $calc(200 - ($width(%text, %font, %size) / 2))
                    drawtext -nr @demo.7 0 %font %size $calc(%xpos + 2) $calc(%ypos + 2) %text
                    drawtext -nr @demo.7 16777215 %font %size %xpos %ypos %text
                }
                else {
                    break
                }
            }
            else {
                hadd demo_endscroll %cnt
            }
        }
        inc %cnt
    }
    if ($hget(demo, part_15_scroll_y) > -8000) {
        hdec demo part_15_scroll_y .5
    }
    drawrot -nc @demo.7 $calc($cos($calc(%c * 1.5)).deg * 8)
    ;drawrot -nc @demo.7 32
    drawcopy -nt @demo.7 8421504 42 110 320 180 @demo 0 0 320 180
    noop $dmDrawframe(demo_15)
}

alias dmInit {
    ;; Configure demo system below. If you don't know what's what, don't touch it.
    var %win $1
    var %params $2-
    window -dak0pfBb +d $1 $2-
    if (%dm.fullscreen == 1) {
        if ($window(@demo2) == $null) {
            set %dm.fs.w $window(-1).w
            set %dm.fs.h $window(-1).h
            window -dak0pfBbo +d @demo2 0 0 %dm.fs.w %dm.fs.h

        }
    }
    set %dm.cs_w $gettok($2, 3, 32)
    set %dm.cs_h $gettok($2, 4, 32)
    set %dm.center_x $calc(%dm.cs_w / 2)
    set %dm.center_y $calc(%dm.cs_h / 2)
    set %- $ticks
    ;; dm.ticks
    set %!       %-
    ;; dm.fps
    set %#         50
    ;; dm.fps_target
    set %$  50
    ;; dm.fps_count
    set %%   %$
    ;; dm.frt_count
    set %&   1000
    ;; dm.frt_target
    set %'  $calc(1000 / %$)
    ;; dm.frt_start
    set %+   %-
    ;; dm.c
    set %c           0
    ;; end of configuration
}

alias partycannon {
    unset %dm.fullscreen
    if ($1 == fs) {
        set %dm.fullscreen 1
        set %dm.flags $2-
    }
    else {
        set %dm.flags $1-
    }
    noop $dmInit(@demo, 0 0 320 180)
    if ($hget(demo) != $null) {
        hfree demo
    }
    hmake demo 20
    ;;-- init
    if ($window(@precalc) != $null) {
        window -c @precalc
    }
    ;; This is a quick and dirty hack to make sure the background
    ;; of some animations are the proper colour, by forcing mIRC's
    ;; window background colour to be black. A proper solution will
    ;; probably be implemented at some point when I can be arsed.
    color background 1
    window -lh @precalc
    filter -fw $qt($scriptdirprecalc.dss) @precalc
    hadd demo preclc_cnt 1
    hadd demo preclc_tot $line(@precalc, 0)
    hadd demo preclc_ctab 1118481 2236962 3355443 4473924 5592405 6710886 7829367 $&
    8947848 10066329 11184810 12303291 13421772 14540253 15658734 16777215 15658734 $&
    14540253 13421772 12303291 11184810 10066329 8947848 7829367 6710886 5592405 $&
    4473924 3355443 2236962
    hadd demo preclc_cfc 1
    hadd demo preclc_part $iif($1, $1, 001)
    hadd demo preclc_fc 1
    init_newer
    ;$+(demo_part_,$1,_init) | $+(demo_part_,$1)
}

alias init_newer {
    var %read $($line(@precalc, $hget(demo, preclc_cnt)), 2)
    %read
    :error
    hinc demo preclc_cnt

    drawrect -nrf @demo 0 0 0 0 320 180

    ;;
    ;; if possible, show IRC output.
    ;;
    ;; please note, this assumes that the channel you're pulling data from is
    ;; the active connection, i.e. the status window you started this demo in!!
    ;;
    ;; you can change the channel below, but it's set to #revision for compo-purposes (:
    ;;

    var %chan #revision
    if ($me ison %chan) {
        var %txt %chan - Live Feed
        var %x $calc(160 - $width(%txt, fixedsys, 18) / 2)
        drawtext -nr @demo 8421504 fixedsys 18 %x 10 %txt
        var %tot $line(%chan, 0)
        var %cnt 1
        ;; Bitches don't know shit 'bout my ugly hacks. Abandon all hope, ye who traverse here.
        ;; this is to make line wrapping work in the preloader btw. I probably coulda done
        ;; this better, but... meh (:
        var %top 24
        while (%cnt <= 15) {
            var %line $strip($line(%chan, $calc((%tot - 15) + %cnt)))
            if (%line != $null) {
                drawtext -nr @demo 16777215 "lucida console" 8 0 $calc(%top + (%cnt * 8)) %line
                if ($len(%line) > 64) {
                    inc %cnt
                    var %line2 $right(%line, -64)
                    drawtext -nr @demo 16777215 "lucida console" 8 0 $calc(%top + (%cnt * 8)) %line2
                    if ($len(%line2) > 64) {
                        inc %cnt
                        var %line3 $right(%line2, -64)
                        drawtext -nr @demo 16777215 "lucida console" 8 0 $calc(%top + (%cnt * 8)) %line3
                        if ($len(%line3) > 64) {
                            inc %cnt
                            var %line4 $right(%line3, -64)
                            drawtext -nr @demo 16777215 "lucida console" 8 0 $calc(%top + (%cnt * 8)) %line4
                            if ($len(%line4) > 64) {
                                inc %cnt
                                var %line5 $right(%line4, -64)
                                drawtext -nr @demo 16777215 "lucida console" 8 0 $calc(%top + (%cnt * 8)) %line5
                            }
                        }
                    }
                }

            }
            inc %cnt
        }
        drawrect -nrf @demo 0 1 0 $calc(178 - %top) 320 50
        drawline -nr @demo 8421504 1 0 $calc(%top + 5) 320 $calc(%top + 5)
        drawline -nr @demo 8421504 1 0 $calc(178 - %top) 320 $calc(178 - %top)
    }

    ;;   show percentage

    var %pct $calc(($hget(demo, preclc_cnt) / $hget(demo, preclc_tot)) * 100)
    var %txt Precalculationizing... .. . $+($round(%pct, 0),$(%))

    var %x $calc(160 - $width(%txt, fixedsys, 18) / 2)
    drawtext -nr @demo 8421504 fixedsys 18 %x 160 %txt
    drawrect -nrfi @demo 8421504 0 5 160 $calc($+(0.,$iif(%pct < 10, $+(0,%pct), %pct)) * 305) 15

    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 %dm.cs_w %dm.cs_h @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    if ($hget(demo, preclc_cnt) > $hget(demo, preclc_tot)) {
        drawrect -rf @demo 0 0 0 0 320 180
        drawpic -c
        set %dm.music $qt($scriptdirdemotune.wav)
        demo_warning
        return
    }
    else {
        .timer -mht 1 0 init_newer
    }
}

alias fixbitmaptext {
    return $replace($1-, ?, ~, :, ^)
}

alias genpalette {
    var %i 0
    while (%i <= 255) {
        var %r $calc($sin($calc($pi * %i / 32)).deg * 256)
        var %g $calc($sin($calc($pi * %i / 64)).deg * 256)
        var %b $calc($sin($calc($pi * %i / 128)).deg * 256)
        echo -s %r %g %b
        var %s $instok(%s, $rgb(%r, %g, %b), $numtok(%s, 32), 32)
        inc %i
    }
    echo -s %s
}


on *:CLOSE:@demo*: {
    splay stop
    echo -s Cleaning up... .. .
   ; var %dir $qt($scriptdirimg\plasma)
   ; noop $findfile(%dir, *, 0, 1, .remove $1-)
   ; rmdir %dir
    var %cnt 1
    while (%cnt <= 8) {
        window -c $+(@demo.,%cnt)
        inc %cnt
    }
}

on *:KEYDOWN:*:32: {
    echo -s insong.pos: $inwave(%dm.music).pos
    echo -s part_15_scroll_y: $hget(demo, part_15_scroll_y)
}

on *:SIGNAL:part_select: {
    set %c 0
    $+(demo_,$1)
}