#version 150

uniform sampler2D reflection;
uniform sampler2D mask;
uniform sampler2D overlay;

in vec2 uv;

out vec4 fragColor;

vec4 screen(vec4 color0, vec4 color1)
{
    vec4 white = vec4(1.0, 1.0, 1.0, 1.0);
    return white - ((white - color0) * (white - color1));
}

void main()
{
    float xc = (uv.x - 0.5) * 0.5;
    float yc = (uv.y - 0.5) * 0.5;
    
    float dist = (1.0 - sqrt(pow(xc, 2.0) + pow(yc, 2.0)) * 3.0);
    
    vec2 lenscoord;
	lenscoord.x = (xc / dist) + 0.5;
	lenscoord.y = (yc / dist) + 0.5;

	vec4 reflection_pixel = texture(reflection, (lenscoord * 1.5) - vec2(0.25));
	vec4 mask_pixel = texture(mask, uv);
	vec4 overlay_pixel = texture(overlay, uv);

	fragColor = screen(overlay_pixel, reflection_pixel * mask_pixel.a);
//	fragColor = reflection_pixel;
}
