Control = {}
Control_mt = { __index = Control }

function Control.Create(root, parentControl)
	local control = {}
	setmetatable(control, Control_mt)

	control.root = root
	control.parentControl = parentControl
	control.isActive = false
	control.isHot = false

	return control
end

function Control:SetActive(isActive)
	self.isActive = value

	if isActive then
		if root.activeControl~=nil then
			--guiState.activeElement:SetActive(false)
			error("Trying to activate a control, while other control is active.")
		end

		root.activeControl = self
		self.isActive = true
	else
		if root.activeControl~=self then
			error("Trying to deactivate a control, while other control is active.")
		end

		root.activeControl = nil
		self.isActive = false
	end
end

function Control:SetHot(isHot)
	self.isHot = isHot
end

function Control:IsOtherControlActive()
	if (self.root.activeControl==nil) then
		return false
	else
		return (self.root.activeControl~=self)
	end
end