function string:split(sep)
	local sep, fields = sep or ":", {}
	local pattern = string.format("([^%s]+)", sep)
	self:gsub(pattern, function(c) fields[#fields+1] = c end)
	return fields
end

function SanitizeMultilineString(source, isShader)
	local res
	if (not isShader) then
		res = source:gsub("\r", "")
		res = res:gsub("\n", "\\n\"\n\t\"")
	else
--[[
		local f = assert(io.open("shadertemp", "w"))
		f:write(source)
		f:close()

--		local cmd = startDirectory.."\\base\\tools\\minifier\\shader_minifier-1.1.1.exe .\\shadertemp --preserve-externals --preserve-all-globals -v --format none -o .\\shadertemp.minified"
		local cmd = startDirectory.."\\base\\tools\\minifier\\shader_minifier-1.1.2.exe .\\shadertemp --preserve-externals --preserve-all-globals -v --format none -o .\\shadertemp.minified"

		print(cmd)
		os.execute(cmd)

		local f = assert(io.open("shadertemp.minified", "r"))
		res = f:read("*all")
		f:close()

		res = res.."\n" -- we need this because fragments need a \n at the end, otherwise concating with e.g. "#define" will fail

		res = res:gsub("\n", "\\n\"\n\t\"")
		]]

		res = source

		res = res:gsub("\t", " ") -- convert tabs to spaces

		res = res:gsub("/%*.-%*/", "") -- remove multiple line comments (from here: http://www.lua.org/pil/20.2.html)

		local lines = res:split("\n")
		for i,line in ipairs(lines) do
			lines[i] = lines[i]:gsub("^%s*(.-)%s*$", "%1") -- trim
			lines[i] = lines[i]:gsub("^(.-)%s*//.*$", "%1") -- remove line comments
		end

		res = table.concat(lines, "\n")

		res = res:gsub("^\n", "") -- remove first empty line
		res = res:gsub("\n+", "\n") -- remove empty lines
--		res = res:gsub("\n$", "") -- last empty line    - NO, we need a newline at the end of the shader fragment

		res = res:gsub("\n", "\\n\"\n\t\"")
		res = res.."\"\n\t\"\\n" -- additional newline
	end
	return res
end

--[[ For testing purposes
str = "   /*hej    \n     l2  \n   \n  \n  \n   asd // asdas*/  hej \n /* abc \n */ \n    l3    \n    l4    \n ///    l5   "
print(str)
print("---")
print("\""..SanitizeMultilineString(str, true).."\"")
]]
