/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkTRNS
extends PngChunk {
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int[] paletteAlpha = new int[0];

    public PngChunkTRNS(ImageInfo imageInfo) {
        super("tRNS", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoAfterPLTE() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = null;
        if (this.imgInfo.greyscale) {
            chunkRaw = this.createEmptyChunk(2, true);
            PngHelper.writeInt2tobytes(this.gray, chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            chunkRaw = this.createEmptyChunk(this.paletteAlpha.length, true);
            for (int i = 0; i < chunkRaw.len; ++i) {
                chunkRaw.data[i] = (byte)this.paletteAlpha[i];
            }
        } else {
            chunkRaw = this.createEmptyChunk(6, true);
            PngHelper.writeInt2tobytes(this.red, chunkRaw.data, 0);
            PngHelper.writeInt2tobytes(this.green, chunkRaw.data, 0);
            PngHelper.writeInt2tobytes(this.blue, chunkRaw.data, 0);
        }
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (this.imgInfo.greyscale) {
            this.gray = PngHelper.readInt2fromBytes(chunkRaw.data, 0);
        } else if (this.imgInfo.indexed) {
            int n = chunkRaw.data.length;
            this.paletteAlpha = new int[n];
            for (int i = 0; i < n; ++i) {
                this.paletteAlpha[i] = chunkRaw.data[i] & 0xFF;
            }
        } else {
            this.red = PngHelper.readInt2fromBytes(chunkRaw.data, 0);
            this.green = PngHelper.readInt2fromBytes(chunkRaw.data, 2);
            this.blue = PngHelper.readInt2fromBytes(chunkRaw.data, 4);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkTRNS pngChunkTRNS = (PngChunkTRNS)pngChunk;
        this.gray = pngChunkTRNS.gray;
        this.red = pngChunkTRNS.red;
        this.green = pngChunkTRNS.red;
        this.blue = pngChunkTRNS.red;
        if (pngChunkTRNS.paletteAlpha != null) {
            this.paletteAlpha = new int[pngChunkTRNS.paletteAlpha.length];
            System.arraycopy(pngChunkTRNS.paletteAlpha, 0, this.paletteAlpha, 0, this.paletteAlpha.length);
        }
    }

    public void setRGB(int n, int n2, int n3) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.red, this.green, this.blue};
    }

    public void setGray(int n) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        this.gray = n;
    }

    public int getGray() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only grayscale images support this");
        }
        return this.gray;
    }

    public void setPalletteAlpha(int[] nArray) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        this.paletteAlpha = nArray;
    }

    public int[] getPalletteAlpha() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images support this");
        }
        return this.paletteAlpha;
    }
}

