/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.TableRow;

public class Table {
    protected int rowCount;
    protected String extension = null;
    protected boolean awfulCSV = false;
    protected String missingString = null;
    protected int missingInt = 0;
    protected long missingLong = 0L;
    protected float missingFloat = Float.NaN;
    protected double missingDouble = Double.NaN;
    protected int missingCategory = -1;
    String[] columnTitles;
    HashMapBlows[] columnCategories;
    HashMap<String, Integer> columnIndices;
    protected Object[] columns;
    static final int STRING = 0;
    static final int INT = 1;
    static final int LONG = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    static final int CATEGORICAL = 5;
    int[] columnTypes;
    PApplet sketch;
    protected RowIterator rowIterator;

    public Table() {
        this.init(null);
    }

    public Table(PApplet sketch) {
        this.init(sketch);
    }

    public Table(PApplet parent, String filename) throws IOException {
        this(parent, filename, null);
    }

    public Table(PApplet parent, String filename, String options) throws IOException {
        this.init(parent);
        String extension = null;
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex != -1 && !(extension = filename.substring(dotIndex + 1).toLowerCase()).equals("csv") && !extension.equals("tsv")) {
            extension = null;
        }
        String[] opts = null;
        if (options != null) {
            for (String opt : opts = options.split("\\s*,\\s*")) {
                if (opt.equals("tsv")) {
                    extension = "tsv";
                    continue;
                }
                if (opt.equals("csv")) {
                    extension = "csv";
                    continue;
                }
                if (opt.equals("newlines")) {
                    this.awfulCSV = true;
                    continue;
                }
                System.err.println(opt + " is not a valid option for loading a Table");
            }
        }
        BufferedReader reader = parent.createReader(filename);
        if (this.awfulCSV) {
            this.parseAwfulCSV(reader);
        } else if ("tsv".equals(extension)) {
            this.parseBasic(reader, true);
        } else if ("csv".equals(extension)) {
            this.parseBasic(reader, false);
        }
    }

    protected void init(PApplet sketch) {
        this.sketch = sketch;
        this.columns = new Object[0];
        this.columnTypes = new int[0];
        this.columnCategories = new HashMapBlows[0];
    }

    public Table(ResultSet rs) {
        this.init(null);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.setColumnCount(columnCount);
            block15: for (int col = 0; col < columnCount; ++col) {
                this.setColumnTitle(col, rsmd.getColumnName(col + 1));
                int type = rsmd.getColumnType(col + 1);
                switch (type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.setColumnType(col, 1);
                        continue block15;
                    }
                    case -5: {
                        this.setColumnType(col, 2);
                        continue block15;
                    }
                    case 6: {
                        this.setColumnType(col, 3);
                        continue block15;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.setColumnType(col, 4);
                    }
                }
            }
            int row = 0;
            while (rs.next()) {
                block17: for (int col = 0; col < columnCount; ++col) {
                    switch (this.columnTypes[col]) {
                        case 0: {
                            this.setString(row, col, rs.getString(col + 1));
                            continue block17;
                        }
                        case 1: {
                            this.setInt(row, col, rs.getInt(col + 1));
                            continue block17;
                        }
                        case 2: {
                            this.setLong(row, col, rs.getLong(col + 1));
                            continue block17;
                        }
                        case 3: {
                            this.setFloat(row, col, rs.getFloat(col + 1));
                            continue block17;
                        }
                        case 4: {
                            this.setDouble(row, col, rs.getDouble(col + 1));
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("column type " + this.columnTypes[col] + " not supported.");
                        }
                    }
                }
                ++row;
            }
        }
        catch (SQLException s) {
            throw new RuntimeException(s);
        }
    }

    public void parseTSV(BufferedReader reader) throws IOException {
        this.parseBasic(reader, true);
    }

    public void parseCSV(BufferedReader reader) throws IOException {
        this.parseBasic(reader, false);
    }

    protected void parseBasic(BufferedReader reader, boolean tsv) throws IOException {
        String line = null;
        int row = 0;
        if (this.rowCount == 0) {
            this.setRowCount(10);
        }
        int prev = 0;
        while ((line = reader.readLine()) != null) {
            int pct;
            if (row == this.getRowCount()) {
                this.setRowCount(row << 1);
            }
            this.setRow(row, tsv ? PApplet.split(line, '\t') : Table.splitLineCSV(line));
            if (++row % 10000 != 0) continue;
            if (row < this.rowCount && (pct = 100 * row / this.rowCount) != prev) {
                System.out.println(pct + "%");
                prev = pct;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (row != this.getRowCount()) {
            this.setRowCount(row);
        }
    }

    public void convertTSV(BufferedReader reader, File outputFile) throws IOException {
        this.convertBasic(reader, true, outputFile);
    }

    protected void convertBasic(BufferedReader reader, boolean tsv, File outputFile) throws IOException {
        String string;
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
        DataOutputStream output = new DataOutputStream(bos);
        output.writeInt(0);
        output.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            output.writeBoolean(true);
            for (String title : this.columnTitles) {
                output.writeUTF(title);
            }
        } else {
            output.writeBoolean(false);
        }
        for (int type : this.columnTypes) {
            output.writeInt(type);
        }
        Object var7_9 = null;
        int prev = -1;
        int row = 0;
        while ((string = reader.readLine()) != null) {
            int pct;
            this.convertRow(output, tsv ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
            if (++row % 10000 != 0 || row >= this.rowCount || (pct = 100 * row / this.rowCount) == prev) continue;
            System.out.println(pct + "%");
            prev = pct;
        }
        int col = 0;
        for (HashMapBlows hmb : this.columnCategories) {
            if (hmb == null) {
                output.writeInt(0);
            } else {
                hmb.write(output);
                hmb.writeln(PApplet.createWriter(new File(this.columnTitles[col] + ".categories")));
            }
            ++col;
        }
        output.flush();
        output.close();
        RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");
        raf.writeInt(this.rowCount);
        raf.close();
    }

    protected void parseAwfulCSV(BufferedReader reader) throws IOException {
        int ch;
        char[] c = new char[100];
        int count = 0;
        boolean insideQuote = false;
        int row = 0;
        int col = 0;
        while ((ch = reader.read()) != -1) {
            if (insideQuote) {
                if (ch == 34) {
                    reader.mark(1);
                    if (reader.read() == 34) {
                        if (count == c.length) {
                            c = PApplet.expand(c);
                        }
                        c[count++] = 34;
                        continue;
                    }
                    reader.reset();
                    insideQuote = false;
                    continue;
                }
                if (count == c.length) {
                    c = PApplet.expand(c);
                }
                c[count++] = (char)ch;
                continue;
            }
            if (ch == 34) {
                insideQuote = true;
                continue;
            }
            if (ch == 13) {
                reader.mark(1);
                if (reader.read() != 10) {
                    reader.reset();
                }
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                ++row;
                col = 0;
                continue;
            }
            if (ch == 10) {
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                ++row;
                col = 0;
                continue;
            }
            if (ch == 44) {
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                this.checkColumn(++col);
                continue;
            }
            if (count == c.length) {
                c = PApplet.expand(c);
            }
            c[count++] = (char)ch;
        }
        if (count > 0) {
            this.setString(row, col, new String(c, 0, count));
        }
    }

    public static String[] splitLineCSV(String line) {
        char[] c = line.toCharArray();
        int rough = 1;
        boolean quote = false;
        for (int i = 0; i < c.length; ++i) {
            if (!quote && c[i] == ',') {
                ++rough;
                continue;
            }
            if (c[i] != '\"') continue;
            quote = !quote;
        }
        String[] pieces = new String[rough];
        int pieceCount = 0;
        int offset = 0;
        while (offset < c.length) {
            int start = offset;
            int stop = Table.nextComma(c, offset);
            offset = stop + 1;
            if (c[start] == '\"' && c[stop - 1] == '\"') {
                --stop;
            }
            int i = ++start;
            int ii = start;
            while (i < stop) {
                if (c[i] == '\"') {
                    ++i;
                }
                if (i != ii) {
                    c[ii] = c[i];
                }
                ++i;
                ++ii;
            }
            String s = new String(c, start, ii - start);
            pieces[pieceCount++] = s;
        }
        for (int i = pieceCount; i < pieces.length; ++i) {
            pieces[i] = "";
        }
        return pieces;
    }

    static int nextComma(char[] c, int index) {
        boolean quote = false;
        for (int i = index; i < c.length; ++i) {
            if (!quote && c[i] == ',') {
                return i;
            }
            if (c[i] != '\"') continue;
            quote = !quote;
        }
        return c.length;
    }

    public void parseInto(String fieldName) {
        Class<?> target = null;
        Object outgoing = null;
        Field targetField = null;
        try {
            Class<?> sketchClass = this.sketch.getClass();
            targetField = sketchClass.getDeclaredField(fieldName);
            PApplet.println("found " + targetField);
            Class<?> targetArray = targetField.getType();
            if (targetArray.isArray()) {
                target = targetArray.getComponentType();
                outgoing = Array.newInstance(target, this.getRowCount());
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        PApplet enclosingObject = this.sketch;
        PApplet.println("enclosing obj is " + enclosingObject);
        Class<?> enclosingClass = target.getEnclosingClass();
        Constructor<?> con = null;
        try {
            if (enclosingClass == null) {
                con = target.getDeclaredConstructor(new Class[0]);
                PApplet.println("no enclosing class");
            } else {
                con = target.getDeclaredConstructor(enclosingClass);
                PApplet.println("enclosed by " + enclosingClass.getName());
            }
            if (!con.isAccessible()) {
                System.out.println("setting constructor to public");
                con.setAccessible(true);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Field[] fields = target.getDeclaredFields();
        ArrayList<Field> inuse = new ArrayList<Field>();
        for (Field field : fields) {
            String name = field.getName();
            if (this.getColumnIndex(name, false) != -1) {
                System.out.println("found field " + name);
                if (!field.isAccessible()) {
                    PApplet.println("  changing field access");
                    field.setAccessible(true);
                }
                inuse.add(field);
                continue;
            }
            System.out.println("skipping field " + name);
        }
        int index = 0;
        try {
            for (TableRow row : this.getRows()) {
                Object item = null;
                item = enclosingClass == null ? con.newInstance(new Object[0]) : con.newInstance(enclosingObject);
                for (Field field : inuse) {
                    String content;
                    String name = field.getName();
                    if (field.getType() == String.class) {
                        field.set(item, row.getString(name));
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        field.setInt(item, row.getInt(name));
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        field.setLong(item, row.getLong(name));
                        continue;
                    }
                    if (field.getType() == Float.TYPE) {
                        field.setFloat(item, row.getFloat(name));
                        continue;
                    }
                    if (field.getType() == Double.TYPE) {
                        field.setDouble(item, row.getDouble(name));
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        content = row.getString(name);
                        if (content == null || !content.toLowerCase().equals("true") && !content.equals("1")) continue;
                        field.setBoolean(item, true);
                        continue;
                    }
                    if (field.getType() != Character.TYPE || (content = row.getString(name)) == null || content.length() <= 0) continue;
                    field.setChar(item, content.charAt(0));
                }
                Array.set(outgoing, index++, item);
            }
            if (!targetField.isAccessible()) {
                PApplet.println("setting target field to public");
                targetField.setAccessible(true);
            }
            targetField.set(this.sketch, outgoing);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void writeTSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            for (int col = 0; col < this.columns.length; ++col) {
                if (col != 0) {
                    writer.print('\t');
                }
                if (this.columnTitles[col] == null) continue;
                writer.print(this.columnTitles[col]);
            }
            writer.println();
        }
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry;
                if (col != 0) {
                    writer.print('\t');
                }
                if ((entry = this.getString(row, col)) == null) continue;
                writer.print(entry);
            }
            writer.println();
        }
        writer.flush();
    }

    public void writeCSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            for (int col = 0; col < this.columns.length; ++col) {
                if (col != 0) {
                    writer.print(',');
                }
                if (this.columnTitles[col] == null) continue;
                this.writeEntryCSV(writer, this.columnTitles[col]);
            }
            writer.println();
        }
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry;
                if (col != 0) {
                    writer.print(',');
                }
                if ((entry = this.getString(row, col)) == null) continue;
                this.writeEntryCSV(writer, entry);
            }
            writer.println();
        }
        writer.flush();
    }

    protected void writeEntryCSV(PrintWriter writer, String entry) {
        if (entry != null) {
            if (entry.indexOf(34) != -1) {
                char[] c = entry.toCharArray();
                writer.print('\"');
                for (int i = 0; i < c.length; ++i) {
                    if (c[i] == '\"') {
                        writer.print("\"\"");
                        continue;
                    }
                    writer.print(c[i]);
                }
                writer.print('\"');
            } else if (entry.indexOf(44) != -1 || entry.indexOf(10) != -1 || entry.indexOf(13) != -1) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else if (entry.length() > 0 && (entry.charAt(0) == ' ' || entry.charAt(entry.length() - 1) == ' ')) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else {
                writer.print(entry);
            }
        }
    }

    public void writeHTML(PrintWriter writer) {
        writer.println("<table>");
        for (int row = 0; row < this.getRowCount(); ++row) {
            writer.println("  <tr>");
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry = this.getString(row, col);
                writer.print("    <td>");
                this.writeEntryHTML(writer, entry);
                writer.println("</td>");
            }
            writer.println("  </tr>");
        }
        writer.println("</table>");
        writer.flush();
    }

    protected void writeEntryHTML(PrintWriter writer, String entry) {
        for (char c : entry.toCharArray()) {
            if (c < ' ' || c > '\u007f') {
                writer.print("&#");
                writer.print((int)c);
                writer.print(';');
                continue;
            }
            writer.print(c);
        }
    }

    public boolean writeCSV(File file) {
        try {
            this.writeCSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean writeTSV(File file) {
        try {
            this.writeTSV(new PrintWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addColumn() {
        this.addColumn(null, 0);
    }

    public void addColumn(String title) {
        this.addColumn(title, 0);
    }

    public void addColumn(String title, int type) {
        this.insertColumn(this.columns.length, title, type);
    }

    public void insertColumn(int index) {
        this.insertColumn(index, null, 0);
    }

    public void insertColumn(int index, String title) {
        this.insertColumn(index, title, 0);
    }

    public void insertColumn(int index, String title, int type) {
        int i;
        if (title != null && this.columnTitles == null) {
            this.columnTitles = new String[this.columns.length];
        }
        if (this.columnTitles != null) {
            this.columnTitles = PApplet.splice(this.columnTitles, title, index);
            this.columnIndices = null;
        }
        this.columnTypes = PApplet.splice(this.columnTypes, type, index);
        HashMapBlows[] catTemp = new HashMapBlows[this.columns.length + 1];
        for (i = 0; i < index; ++i) {
            catTemp[i] = this.columnCategories[i];
        }
        catTemp[index] = new HashMapBlows();
        for (i = index; i < this.columns.length; ++i) {
            catTemp[i + 1] = this.columnCategories[i];
        }
        this.columnCategories = catTemp;
        Object[] temp = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, temp, 0, index);
        System.arraycopy(this.columns, index, temp, index + 1, this.columns.length - index);
        this.columns = temp;
        switch (type) {
            case 1: {
                this.columns[index] = new int[this.rowCount];
                break;
            }
            case 2: {
                this.columns[index] = new long[this.rowCount];
                break;
            }
            case 3: {
                this.columns[index] = new float[this.rowCount];
                break;
            }
            case 4: {
                this.columns[index] = new double[this.rowCount];
                break;
            }
            case 0: {
                this.columns[index] = new String[this.rowCount];
                break;
            }
            case 5: {
                this.columns[index] = new int[this.rowCount];
            }
        }
    }

    public void removeColumn(String dead) {
        this.removeColumn(this.getColumnIndex(dead));
    }

    public void removeColumn(int index) {
        Object[] temp = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, temp, 0, index);
        System.arraycopy(this.columns, index + 1, temp, index, this.columns.length - index + 1);
        this.columns = temp;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnCount(int newCount) {
        int oldCount = this.columns.length;
        if (oldCount != newCount) {
            this.columns = (Object[])PApplet.expand(this.columns, newCount);
            for (int c = oldCount; c < newCount; ++c) {
                this.columns[c] = new String[this.rowCount];
            }
            if (this.columnTitles != null) {
                this.columnTitles = PApplet.expand(this.columnTitles, newCount);
            }
            this.columnTypes = PApplet.expand(this.columnTypes, newCount);
            this.columnCategories = (HashMapBlows[])PApplet.expand(this.columnCategories, newCount);
        }
    }

    public void setColumnType(String columnName, String columnType) {
        this.setColumnType(this.checkColumnIndex(columnName), columnType);
    }

    public void setColumnType(int column, String columnType) {
        int type = -1;
        if (columnType.equals("String")) {
            type = 0;
        } else if (columnType.equals("int")) {
            type = 1;
        } else if (columnType.equals("long")) {
            type = 2;
        } else if (columnType.equals("float")) {
            type = 3;
        } else if (columnType.equals("double")) {
            type = 4;
        } else if (columnType.equals("categorical")) {
            type = 5;
        } else {
            throw new IllegalArgumentException("'" + columnType + "' is not a valid column type.");
        }
        this.setColumnType(column, type);
    }

    protected void setColumnType(String columnName, int newType) {
        this.setColumnType(this.checkColumnIndex(columnName), newType);
    }

    protected void setColumnType(int column, int newType) {
        switch (newType) {
            case 1: {
                int[] intData = new int[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    intData[row] = PApplet.parseInt(s, this.missingInt);
                }
                this.columns[column] = intData;
                break;
            }
            case 2: {
                long[] longData = new long[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    try {
                        longData[row] = Long.parseLong(s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        longData[row] = this.missingLong;
                    }
                }
                this.columns[column] = longData;
                break;
            }
            case 3: {
                float[] floatData = new float[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    floatData[row] = PApplet.parseFloat(s, this.missingFloat);
                }
                this.columns[column] = floatData;
                break;
            }
            case 4: {
                double[] doubleData = new double[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    try {
                        doubleData[row] = Double.parseDouble(s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        doubleData[row] = this.missingDouble;
                    }
                }
                this.columns[column] = doubleData;
                break;
            }
            case 0: {
                if (this.columnTypes[column] == 0) break;
                String[] stringData = new String[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    stringData[row] = this.getString(row, column);
                }
                this.columns[column] = stringData;
                break;
            }
            case 5: {
                int[] indexData = new int[this.rowCount];
                HashMapBlows categories = new HashMapBlows();
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    indexData[row] = categories.index(s);
                }
                this.columnCategories[column] = categories;
                this.columns[column] = indexData;
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
        this.columnTypes[column] = newType;
    }

    public void setTableType(String type) {
        for (int col = 0; col < this.columns.length; ++col) {
            this.setColumnType(col, type);
        }
    }

    public void setColumnTypes(Table dictionary) {
        this.setColumnTitles(dictionary.getStringColumn(0));
        if (dictionary.getColumnCount() > 1) {
            for (int i = 0; i < dictionary.getRowCount(); ++i) {
                this.setColumnType(i, dictionary.getString(i, 1));
            }
        }
    }

    public String[] removeTitleRow() {
        String[] titles = this.getStringRow(0);
        this.removeRow(0);
        this.setColumnTitles(titles);
        return titles;
    }

    public void setColumnTitles(String[] titles) {
        if (titles != null) {
            this.checkColumn(titles.length - 1);
        }
        this.columnTitles = titles;
        this.columnIndices = null;
    }

    public void setColumnTitle(int column, String title) {
        this.checkColumn(column);
        if (this.columnTitles == null) {
            this.columnTitles = new String[this.getColumnCount()];
        }
        this.columnTitles[column] = title;
        this.columnIndices = null;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String getColumnTitle(int col) {
        return this.columnTitles == null ? null : this.columnTitles[col];
    }

    public int getColumnIndex(String name) {
        return this.getColumnIndex(name, true);
    }

    protected int getColumnIndex(String name, boolean report) {
        Integer index;
        if (this.columnTitles == null) {
            if (report) {
                System.err.println("Can't get column indices because no column titles are set.");
            }
            return -1;
        }
        if (this.columnIndices == null) {
            this.columnIndices = new HashMap();
            for (int col = 0; col < this.columns.length; ++col) {
                this.columnIndices.put(this.columnTitles[col], col);
            }
        }
        if ((index = this.columnIndices.get(name)) == null) {
            if (report) {
                System.err.println("No column named '" + name + "' was found.");
            }
            return -1;
        }
        return index;
    }

    public int checkColumnIndex(String title) {
        int index = this.getColumnIndex(title, false);
        if (index != -1) {
            return index;
        }
        this.addColumn(title);
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int newCount) {
        if (newCount != this.rowCount) {
            if (newCount > 1000000) {
                System.out.println("setting row count to " + PApplet.nfc(newCount));
            }
            long t = System.currentTimeMillis();
            for (int col = 0; col < this.columns.length; ++col) {
                switch (this.columnTypes[col]) {
                    case 1: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                        break;
                    }
                    case 2: {
                        this.columns[col] = PApplet.expand((long[])this.columns[col], newCount);
                        break;
                    }
                    case 3: {
                        this.columns[col] = PApplet.expand((float[])this.columns[col], newCount);
                        break;
                    }
                    case 4: {
                        this.columns[col] = PApplet.expand((double[])this.columns[col], newCount);
                        break;
                    }
                    case 0: {
                        this.columns[col] = PApplet.expand((String[])this.columns[col], newCount);
                        break;
                    }
                    case 5: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                    }
                }
                if (newCount <= 1000000) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (newCount > 1000000) {
                int ms = (int)(System.currentTimeMillis() - t);
                System.out.println("  resize took " + PApplet.nfc(ms) + " ms");
            }
        }
        this.rowCount = newCount;
    }

    public void addRow() {
        this.setRowCount(this.rowCount + 1);
    }

    public void addRow(String[] columns) {
        this.setRow(this.getRowCount(), columns);
    }

    public void insertRow(int insert, String[] data) {
        block7: for (int col = 0; col < this.columns.length; ++col) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, intTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = intTemp;
                    continue block7;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, longTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = longTemp;
                    continue block7;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, floatTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = floatTemp;
                    continue block7;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, doubleTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = doubleTemp;
                    continue block7;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, stringTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = stringTemp;
                    continue block7;
                }
            }
        }
        this.setRow(insert, data);
        ++this.rowCount;
    }

    public void removeRow(int dead) {
        block7: for (int col = 0; col < this.columns.length; ++col) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, intTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = intTemp;
                    continue block7;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, longTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = longTemp;
                    continue block7;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, floatTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = floatTemp;
                    continue block7;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, doubleTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = doubleTemp;
                    continue block7;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, dead);
                    System.arraycopy(this.columns[col], dead + 1, stringTemp, dead, this.rowCount - dead - 1);
                    this.columns[col] = stringTemp;
                }
            }
        }
        --this.rowCount;
    }

    public void setRow(int row, String[] pieces) {
        this.checkSize(row, pieces.length - 1);
        for (int col = 0; col < pieces.length; ++col) {
            this.setRowCol(row, col, pieces[col]);
        }
    }

    protected void setRowCol(int row, int col, String piece) {
        switch (this.columnTypes[col]) {
            case 0: {
                String[] stringData = (String[])this.columns[col];
                stringData[row] = piece;
                break;
            }
            case 1: {
                int[] intData = (int[])this.columns[col];
                intData[row] = PApplet.parseInt(piece, this.missingInt);
                break;
            }
            case 2: {
                long[] longData = (long[])this.columns[col];
                try {
                    longData[row] = Long.parseLong(piece);
                }
                catch (NumberFormatException nfe) {
                    longData[row] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] floatData = (float[])this.columns[col];
                floatData[row] = PApplet.parseFloat(piece, this.missingFloat);
                break;
            }
            case 4: {
                double[] doubleData = (double[])this.columns[col];
                try {
                    doubleData[row] = Double.parseDouble(piece);
                }
                catch (NumberFormatException nfe) {
                    doubleData[row] = this.missingDouble;
                }
                break;
            }
            case 5: {
                int[] indexData = (int[])this.columns[col];
                indexData[row] = this.columnCategories[col].index(piece);
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public void convertRow(DataOutputStream output, String[] pieces) throws IOException {
        int col;
        if (pieces.length > this.getColumnCount()) {
            throw new IllegalArgumentException("Row with too many columns: " + PApplet.join(pieces, ","));
        }
        block20: for (col = 0; col < pieces.length; ++col) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF(pieces[col]);
                    continue block20;
                }
                case 1: {
                    output.writeInt(PApplet.parseInt(pieces[col], this.missingInt));
                    continue block20;
                }
                case 2: {
                    try {
                        output.writeLong(Long.parseLong(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeLong(this.missingLong);
                    }
                    continue block20;
                }
                case 3: {
                    output.writeFloat(PApplet.parseFloat(pieces[col], this.missingFloat));
                    continue block20;
                }
                case 4: {
                    try {
                        output.writeDouble(Double.parseDouble(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeDouble(this.missingDouble);
                    }
                    continue block20;
                }
                case 5: {
                    output.writeInt(this.columnCategories[col].index(pieces[col]));
                }
            }
        }
        block21: for (col = pieces.length; col < this.getColumnCount(); ++col) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF("");
                    continue block21;
                }
                case 1: {
                    output.writeInt(this.missingInt);
                    continue block21;
                }
                case 2: {
                    output.writeLong(this.missingLong);
                    continue block21;
                }
                case 3: {
                    output.writeFloat(this.missingFloat);
                    continue block21;
                }
                case 4: {
                    output.writeDouble(this.missingDouble);
                    continue block21;
                }
                case 5: {
                    output.writeInt(this.missingCategory);
                }
            }
        }
    }

    protected void convertRowCol(DataOutputStream output, int row, int col, String piece) {
        switch (this.columnTypes[col]) {
            case 0: {
                String[] stringData = (String[])this.columns[col];
                stringData[row] = piece;
                break;
            }
            case 1: {
                int[] intData = (int[])this.columns[col];
                intData[row] = PApplet.parseInt(piece, this.missingInt);
                break;
            }
            case 2: {
                long[] longData = (long[])this.columns[col];
                try {
                    longData[row] = Long.parseLong(piece);
                }
                catch (NumberFormatException nfe) {
                    longData[row] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] floatData = (float[])this.columns[col];
                floatData[row] = PApplet.parseFloat(piece, this.missingFloat);
                break;
            }
            case 4: {
                double[] doubleData = (double[])this.columns[col];
                try {
                    doubleData[row] = Double.parseDouble(piece);
                }
                catch (NumberFormatException nfe) {
                    doubleData[row] = this.missingDouble;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public Iterable<TableRow> getRows() {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                if (Table.this.rowIterator == null) {
                    Table.this.rowIterator = new RowIterator();
                }
                Table.this.rowIterator.reset();
                return Table.this.rowIterator;
            }
        };
    }

    public Iterator<TableRow> createIterator() {
        return new RowIterator();
    }

    public static Iterator<TableRow> createIterator(final ResultSet rs) {
        return new Iterator<TableRow>(){
            boolean already;

            @Override
            public boolean hasNext() {
                this.already = true;
                try {
                    return rs.next();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public TableRow next() {
                if (!this.already) {
                    try {
                        rs.next();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.already = false;
                }
                return new TableRow(){

                    @Override
                    public double getDouble(int column) {
                        try {
                            return rs.getDouble(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public double getDouble(String columnName) {
                        try {
                            return rs.getDouble(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public float getFloat(int column) {
                        try {
                            return rs.getFloat(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public float getFloat(String columnName) {
                        try {
                            return rs.getFloat(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public int getInt(int column) {
                        try {
                            return rs.getInt(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public int getInt(String columnName) {
                        try {
                            return rs.getInt(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public long getLong(int column) {
                        try {
                            return rs.getLong(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public long getLong(String columnName) {
                        try {
                            return rs.getLong(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public String getString(int column) {
                        try {
                            return rs.getString(column);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public String getString(String columnName) {
                        try {
                            return rs.getString(columnName);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("remove() not supported");
            }
        };
    }

    public int getInt(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 1) {
            int[] intData = (int[])this.columns[column];
            return intData[row];
        }
        String str = this.getString(row, column);
        return str == null || str.equals(this.missingString) ? this.missingInt : PApplet.parseInt(str, this.missingInt);
    }

    public int getInt(int row, String columnName) {
        return this.getInt(row, this.getColumnIndex(columnName));
    }

    public void setMissingInt(int value) {
        this.missingInt = value;
    }

    public void setInt(int row, int column, int what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 1) {
                throw new IllegalArgumentException("Column " + column + " is not an int column.");
            }
            int[] intData = (int[])this.columns[column];
            intData[row] = what;
        }
    }

    public int[] getIntColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getIntColumn(col);
    }

    public int[] getIntColumn(int col) {
        int[] outgoing = new int[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getInt(row, col);
        }
        return outgoing;
    }

    public int[] getIntRow(int row) {
        int[] outgoing = new int[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getInt(row, col);
        }
        return outgoing;
    }

    public long getLong(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 2) {
            long[] longData = (long[])this.columns[column];
            return longData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingLong;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingLong;
        }
    }

    public long getLong(int row, String columnName) {
        return this.getLong(row, this.getColumnIndex(columnName));
    }

    public void setMissingLong(long value) {
        this.missingLong = value;
    }

    public void setLong(int row, int column, long what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 2) {
                throw new IllegalArgumentException("Column " + column + " is not a 'long' column.");
            }
            long[] longData = (long[])this.columns[column];
            longData[row] = what;
        }
    }

    public long[] getLongColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getLongColumn(col);
    }

    public long[] getLongColumn(int col) {
        long[] outgoing = new long[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getLong(row, col);
        }
        return outgoing;
    }

    public long[] getLongRow(int row) {
        long[] outgoing = new long[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getLong(row, col);
        }
        return outgoing;
    }

    public float getFloat(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 3) {
            float[] floatData = (float[])this.columns[column];
            return floatData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingFloat;
        }
        return PApplet.parseFloat(str, this.missingFloat);
    }

    public float getFloat(int row, String columnName) {
        return this.getFloat(row, this.getColumnIndex(columnName));
    }

    public void setMissingFloat(float value) {
        this.missingFloat = value;
    }

    public void setFloat(int row, int column, float what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 3) {
                throw new IllegalArgumentException("Column " + column + " is not a float column.");
            }
            float[] longData = (float[])this.columns[column];
            longData[row] = what;
        }
    }

    public float[] getFloatColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getFloatColumn(col);
    }

    public float[] getFloatColumn(int col) {
        float[] outgoing = new float[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getFloat(row, col);
        }
        return outgoing;
    }

    public float[] getFloatRow(int row) {
        float[] outgoing = new float[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getFloat(row, col);
        }
        return outgoing;
    }

    public double getDouble(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 4) {
            double[] doubleData = (double[])this.columns[column];
            return doubleData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingDouble;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingDouble;
        }
    }

    public double getDouble(int row, String columnName) {
        return this.getDouble(row, this.getColumnIndex(columnName));
    }

    public void setMissingDouble(double value) {
        this.missingDouble = value;
    }

    public void setDouble(int row, int column, double what) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(what));
        } else {
            this.checkSize(row, column);
            if (this.columnTypes[column] != 4) {
                throw new IllegalArgumentException("Column " + column + " is not a 'double' column.");
            }
            double[] doubleData = (double[])this.columns[column];
            doubleData[row] = what;
        }
    }

    public double[] getDoubleColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getDoubleColumn(col);
    }

    public double[] getDoubleColumn(int col) {
        double[] outgoing = new double[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getDouble(row, col);
        }
        return outgoing;
    }

    public double[] getDoubleRow(int row) {
        double[] outgoing = new double[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getDouble(row, col);
        }
        return outgoing;
    }

    public String getString(int row, int col) {
        this.checkBounds(row, col);
        if (this.columnTypes[col] == 0) {
            String[] stringData = (String[])this.columns[col];
            return stringData[row];
        }
        if (this.columnTypes[col] == 5) {
            int index = this.getInt(row, col);
            return this.columnCategories[col].key(index);
        }
        return String.valueOf(Array.get(this.columns[col], row));
    }

    public String getString(int row, String columnName) {
        return this.getString(row, this.getColumnIndex(columnName));
    }

    public void setMissingString(String value) {
        this.missingString = value;
    }

    public void setString(int row, int column, String what) {
        this.checkSize(row, column);
        if (this.columnTypes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not a String column.");
        }
        String[] stringData = (String[])this.columns[column];
        stringData[row] = what;
    }

    public void setString(int row, String columnName, String what) {
        int column = this.checkColumnIndex(columnName);
        this.setString(row, column, what);
    }

    public String[] getStringColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getStringColumn(col);
    }

    public String[] getStringColumn(int col) {
        String[] outgoing = new String[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            outgoing[i] = this.getString(i, col);
        }
        return outgoing;
    }

    public String[] getStringRow(int row) {
        String[] outgoing = new String[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getString(row, col);
        }
        return outgoing;
    }

    public void makeNullEmpty() {
        for (int col = 0; col < this.columns.length; ++col) {
            if (this.columnTypes[col] != 0) continue;
            String[] stringData = (String[])this.columns[col];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] != null) continue;
                stringData[row] = "";
            }
        }
    }

    public void makeEmptyNull() {
        for (int col = 0; col < this.columns.length; ++col) {
            if (this.columnTypes[col] != 0) continue;
            String[] stringData = (String[])this.columns[col];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null || stringData[row].length() != 0) continue;
                stringData[row] = null;
            }
        }
    }

    public float getMaxFloat() {
        boolean found = false;
        float max = -3.4028235E38f;
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                float value = this.getFloat(row, col);
                if (Float.isNaN(value)) continue;
                if (!found) {
                    max = value;
                    found = true;
                    continue;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        return found ? max : this.missingFloat;
    }

    public void removeTokens(String tokens) {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            this.removeTokens(tokens, col);
        }
    }

    public void removeTokens(String tokens, int column) {
        for (int row = 0; row < this.rowCount; ++row) {
            String s = this.getString(row, column);
            if (s == null) continue;
            char[] c = s.toCharArray();
            int index = 0;
            for (int j = 0; j < c.length; ++j) {
                if (tokens.indexOf(c[j]) != -1) continue;
                if (index != j) {
                    c[index] = c[j];
                }
                ++index;
            }
            if (index == c.length) continue;
            this.setString(row, column, new String(c, 0, index));
        }
    }

    public void removeTokens(String tokens, String column) {
        this.removeTokens(tokens, this.getColumnIndex(column));
    }

    public int findRow(String what, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (what == null) {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] != null) continue;
                    return row;
                }
            } else {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] == null || !stringData[row].equals(what)) continue;
                    return row;
                }
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (!(str == null ? what == null : str.equals(what))) continue;
                return row;
            }
        }
        return -1;
    }

    public int findRow(String what, String columnName) {
        return this.findRow(what, this.getColumnIndex(columnName));
    }

    public int[] findRows(String what, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (what == null) {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] != null) continue;
                    outgoing[count++] = row;
                }
            } else {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] == null || !stringData[row].equals(what)) continue;
                    outgoing[count++] = row;
                }
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null) {
                    if (what != null) continue;
                    outgoing[count++] = row;
                    continue;
                }
                if (!str.equals(what)) continue;
                outgoing[count++] = row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] findRows(String what, String columnName) {
        return this.findRows(what, this.getColumnIndex(columnName));
    }

    public int matchRow(String regexp, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null || PApplet.match(stringData[row], regexp) == null) continue;
                return row;
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null || PApplet.match(str, regexp) == null) continue;
                return row;
            }
        }
        return -1;
    }

    public int matchRow(String what, String columnName) {
        return this.matchRow(what, this.getColumnIndex(columnName));
    }

    public int[] matchRows(String regexp, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null || PApplet.match(stringData[row], regexp) == null) continue;
                outgoing[count++] = row;
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null || PApplet.match(str, regexp) == null) continue;
                outgoing[count++] = row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] matchRows(String what, String columnName) {
        return this.matchRows(what, this.getColumnIndex(columnName));
    }

    public void replaceAll(String regex, String replacement, int column) {
        this.checkBounds(-1, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null) continue;
                stringData[row] = stringData[row].replaceAll(regex, replacement);
            }
        } else {
            throw new IllegalArgumentException("replaceAll() can only be used on String columns");
        }
    }

    public void replaceAll(String regex, String replacement, String columnName) {
        this.replaceAll(regex, replacement, this.getColumnIndex(columnName));
    }

    protected void checkColumn(int col) {
        if (col >= this.columns.length) {
            this.setColumnCount(col + 1);
        }
    }

    protected void checkRow(int row) {
        if (row >= this.rowCount) {
            this.setRowCount(row + 1);
        }
    }

    protected void checkSize(int row, int col) {
        this.checkRow(row);
        this.checkColumn(col);
    }

    protected void checkBounds(int row, int column) {
        if (row < 0 || row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException("Row " + row + " does not exist.");
        }
        if (column < 0 || column >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException("Column " + column + " does not exist.");
        }
    }

    public Table createSubset(int[] rowSubset) {
        Table newbie = new Table();
        newbie.setColumnTitles(this.columnTitles);
        newbie.columnTypes = this.columnTypes;
        newbie.setRowCount(rowSubset.length);
        for (int i = 0; i < rowSubset.length; ++i) {
            int row = rowSubset[i];
            block8: for (int col = 0; col < this.columns.length; ++col) {
                switch (this.columnTypes[col]) {
                    case 0: {
                        newbie.setString(i, col, this.getString(row, col));
                        continue block8;
                    }
                    case 1: {
                        newbie.setInt(i, col, this.getInt(row, col));
                        continue block8;
                    }
                    case 2: {
                        newbie.setLong(i, col, this.getLong(row, col));
                        continue block8;
                    }
                    case 3: {
                        newbie.setFloat(i, col, this.getFloat(row, col));
                        continue block8;
                    }
                    case 4: {
                        newbie.setDouble(i, col, this.getDouble(row, col));
                    }
                }
            }
        }
        return newbie;
    }

    public String[] getUnique(String column) {
        return this.getUnique(this.getColumnIndex(column));
    }

    public String[] getUnique(int column) {
        HashMapSucks found = new HashMapSucks();
        for (int row = 0; row < this.getRowCount(); ++row) {
            found.check(this.getString(row, column));
        }
        String[] outgoing = new String[found.size()];
        found.keySet().toArray(outgoing);
        return outgoing;
    }

    public HashMap<String, Integer> getUniqueCount(String columnName) {
        return this.getUniqueCount(this.getColumnIndex(columnName));
    }

    public HashMap<String, Integer> getUniqueCount(int column) {
        HashMapSucks outgoing = new HashMapSucks();
        for (int row = 0; row < this.rowCount; ++row) {
            String entry = this.getString(row, column);
            if (entry == null) continue;
            outgoing.increment(entry);
        }
        return outgoing;
    }

    public HashMap<String, Integer> getRowLookup(int col) {
        HashMap<String, Integer> outgoing = new HashMap<String, Integer>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            outgoing.put(this.getString(row, col), row);
        }
        return outgoing;
    }

    public void trim() {
        for (int col = 0; col < this.columns.length; ++col) {
            String[] stringData = (String[])this.columns[col];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null) continue;
                stringData[row] = PApplet.trim(stringData[row]);
            }
        }
    }

    class HashMapSucks
    extends HashMap<String, Integer> {
        HashMapSucks() {
        }

        void increment(String what) {
            Integer value = (Integer)this.get(what);
            if (value == null) {
                this.put(what, 1);
            } else {
                this.put(what, value + 1);
            }
        }

        void check(String what) {
            if (this.get(what) == null) {
                this.put(what, 0);
            }
        }
    }

    class HashMapBlows {
        HashMap<String, Integer> dataToIndex = new HashMap();
        ArrayList<String> indexToData = new ArrayList();

        HashMapBlows() {
        }

        int index(String key) {
            Integer value = this.dataToIndex.get(key);
            if (value != null) {
                return value;
            }
            int v = this.dataToIndex.size();
            this.dataToIndex.put(key, v);
            this.indexToData.add(key);
            return v;
        }

        String key(int index) {
            return this.indexToData.get(index);
        }

        int size() {
            return this.dataToIndex.size();
        }

        void write(DataOutputStream output) throws IOException {
            output.writeInt(this.size());
            for (String str : this.indexToData) {
                output.writeUTF(str);
            }
        }

        void writeln(PrintWriter writer) throws IOException {
            for (String str : this.indexToData) {
                writer.println(str);
            }
            writer.flush();
            writer.close();
        }

        void read(DataInputStream input) throws IOException {
            int count = input.readInt();
            this.dataToIndex = new HashMap(count);
            for (int i = 0; i < count; ++i) {
                String str = input.readUTF();
                this.dataToIndex.put(str, i);
                this.indexToData.add(str);
            }
        }
    }

    class RowIterator
    implements Iterator<TableRow> {
        int row;
        TableRow tableRow = new TableRow(){

            @Override
            public String getString(int column) {
                return Table.this.getString(RowIterator.this.row, column);
            }

            @Override
            public String getString(String columnName) {
                return Table.this.getString(RowIterator.this.row, columnName);
            }

            @Override
            public int getInt(int column) {
                return Table.this.getInt(RowIterator.this.row, column);
            }

            @Override
            public int getInt(String columnName) {
                return Table.this.getInt(RowIterator.this.row, columnName);
            }

            @Override
            public long getLong(int column) {
                return Table.this.getLong(RowIterator.this.row, column);
            }

            @Override
            public long getLong(String columnName) {
                return Table.this.getLong(RowIterator.this.row, columnName);
            }

            @Override
            public float getFloat(int column) {
                return Table.this.getFloat(RowIterator.this.row, column);
            }

            @Override
            public float getFloat(String columnName) {
                return Table.this.getFloat(RowIterator.this.row, columnName);
            }

            @Override
            public double getDouble(int column) {
                return Table.this.getDouble(RowIterator.this.row, column);
            }

            @Override
            public double getDouble(String columnName) {
                return Table.this.getDouble(RowIterator.this.row, columnName);
            }
        };

        RowIterator() {
        }

        @Override
        public void remove() {
            Table.this.removeRow(this.row);
        }

        @Override
        public TableRow next() {
            ++this.row;
            return this.tableRow;
        }

        @Override
        public boolean hasNext() {
            return this.row + 1 < Table.this.getRowCount();
        }

        public void reset() {
            this.row = -1;
        }
    }
}

