/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

public enum FilterType {
    FILTER_NONE(0),
    FILTER_SUB(1),
    FILTER_UP(2),
    FILTER_AVERAGE(3),
    FILTER_PAETH(4),
    FILTER_DEFAULT(-1),
    FILTER_AGGRESSIVE(-2),
    FILTER_ALTERNATE(-3),
    FILTER_VERYAGGRESSIVE(-4);

    public final int val;

    private FilterType(int n2) {
        this.val = n2;
    }

    public static FilterType getByVal(int n) {
        for (FilterType filterType : FilterType.values()) {
            if (filterType.val != n) continue;
            return filterType;
        }
        return null;
    }

    public static int unfilterRowNone(int n) {
        return n & 0xFF;
    }

    public static int unfilterRowSub(int n, int n2) {
        return n + n2 & 0xFF;
    }

    public static int unfilterRowUp(int n, int n2) {
        return n + n2 & 0xFF;
    }

    public static int unfilterRowAverage(int n, int n2, int n3) {
        return n + (n2 + n3) / 2 & 0xFF;
    }

    public static int unfilterRowPaeth(int n, int n2, int n3, int n4) {
        return n + FilterType.filterPaethPredictor(n2, n3, n4) & 0xFF;
    }

    public static int filterPaethPredictor(int n, int n2, int n3) {
        int n4;
        int n5 = n + n2 - n3;
        int n6 = n5 >= n ? n5 - n : n - n5;
        int n7 = n5 >= n2 ? n5 - n2 : n2 - n5;
        int n8 = n4 = n5 >= n3 ? n5 - n3 : n3 - n5;
        if (n6 <= n7 && n6 <= n4) {
            return n;
        }
        if (n7 <= n4) {
            return n2;
        }
        return n3;
    }
}

