#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "main.h"
#include "player.h"

player_t *players = 0;
player_t *me;
int player_count = 0;

player_t *get_player(const char *name)
{
    player_t *current = players;
    while (current) {
        if (strcmp(current->name, name) == 0) {
            return current;
        }
        current = current->next;
    }
    return 0;
}

player_t *get_player_by_index(int index, player_t *skip)
{
    player_t *player = players;
    int i = 0;
    while (player) {
        if (skip != 0 && player == skip) {
            player = player->next;
        } else {
            if (i == index) {
                break;
            } else {
                player = player->next;
                i++;
            }
        }
    }
    return player;
}

player_t *_alloc_player()
{
    player_t *player = calloc(1, sizeof(player_t));
    player->next = players;
    players = player;
    player_count++;
    return player;
}

int _parse_weapon_from_json(json_t *json)
{
    const char *name = json_string_value(json_object_get(json, "name"));
    int weapon;
    if (strcmp(name, "laser") == 0) {
        weapon = LASER;
    } else if (strcmp(name, "mortar") == 0) {
        weapon = MORTAR;
    } else if (strcmp(name, "droid") == 0) {
        weapon = DROID;
    } else {
        assert(0);
    }
    int level = json_integer_value(json_object_get(json, "level"));
    assert(level >= 1 && level <= 3);
    weapon += level;
    return weapon;
}

int update_player_from_json(int initial, json_t *json)
{
    player_t *player;
    const char *player_name = json_string_value(
        json_object_get(json, "name"));
    if (initial) {
        player = _alloc_player();
        player->name = malloc(sizeof(char) * (strlen(player_name) + 1));
        strcpy(player->name, player_name);

        if (strcmp(NAME, player->name) == 0) {
            me = player;
            debug("FOUND PLAYER");
        }
    } else {
        player = get_player(player_name);
    }

    json_t *primary_weapon_json = json_object_get(json, "primary-weapon"),
        *secondary_weapon_json = json_object_get(json, "secondary-weapon");
    if (primary_weapon_json && secondary_weapon_json) {
        player->weapons[0] = _parse_weapon_from_json(primary_weapon_json);
        player->weapons[1] = _parse_weapon_from_json(secondary_weapon_json);
    }

    json_t *position_json = json_object_get(json, "position");
    if (position_json) {
        const char *position = json_string_value(position_json);
        sscanf(position, "%d, %d", &player->j, &player->k);
    }

    json_t *health_json = json_object_get(json, "health");
    if (health_json) {
        player->hp = json_integer_value(health_json);
    }

    json_t *score_json = json_object_get(json, "score");
    if (score_json) {
        player->score = json_integer_value(score_json);
    }

    printf("Player %s weapons %s %s\n", player->name,
        weapon_to_string(player->weapons[0]),
        weapon_to_string(player->weapons[1]));

    return player == me;
}

char *weapon_to_string(int weapon)
{
    if (weapon == 0) {
        return "unknown";
    }
    switch (weapon & 0xc) {
        case LASER: return "laser";
        case MORTAR: return "mortar";
        case DROID: return "droid";
    }
}
