/*
 * Decompiled with CFR 0.152.
 */
package skyport.ais;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import skyport.Coordinate;
import skyport.PlayerResources;
import skyport.Resources;
import skyport.SkyportException;
import skyport.WeaponResource;
import skyport.ais.Ai;
import skyport.algorithms.astar.Node;
import skyport.algorithms.astar.Nodemap;
import skyport.constants.GameConstants;
import skyport.enums.Direction;
import skyport.enums.Tile;
import skyport.enums.WeaponType;
import skyport.json.PlayerBean;
import skyport.json.WeaponBean;

public class Kaporder
extends Ai {
    private static final String AINAME = "kaporder";
    private int actionsLeft = 0;

    public Kaporder() {
        super(AINAME);
    }

    @Override
    protected void processTurn() throws JsonProcessingException {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        this.actionsLeft = 3;
        List<Direction> dirSequence = null;
        int index = 0;
        Coordinate target = null;
        PlayerResources playerResources = this.game.getResources().getPlayerResources(this.aiName);
        System.out.println("My turn! Turn: " + this.game.getTurn() + " Scrap: " + playerResources.getResourceCount(Tile.SCRAP) + " Rubidium: " + playerResources.getResourceCount(Tile.RUBIDIUM) + " Explosium: " + playerResources.getResourceCount(Tile.EXPLODIUM));
        Coordinate pos = currentPlayer.getPosition();
        PlayerBean closestPlayer = this.game.getClosestPlayerFrom(pos);
        while (this.actionsLeft > 0) {
            if (closestPlayer != null) {
                target = closestPlayer.getPosition();
            } else {
                ArrayList<List<Node>> resourceRoutes = new ArrayList<List<Node>>();
                Nodemap nodemap = this.game.getNodemap();
                Tile[] tileArray = Tile.values();
                int n = tileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate resourceCoord;
                    Tile tile = tileArray[n2];
                    if (this.needResource(tile) && (resourceCoord = this.game.getCoordinateToClosestTileFrom(pos, tile)) != null) {
                        resourceRoutes.add(nodemap.getRoute(pos, resourceCoord));
                    }
                    ++n2;
                }
                int minDistance = Integer.MAX_VALUE;
                List shortestRoute = null;
                for (List list : resourceRoutes) {
                    int nodes = list.size();
                    if (nodes >= minDistance) continue;
                    minDistance = nodes;
                    shortestRoute = list;
                }
                if (shortestRoute != null) {
                    List<Direction> list = this.getDirectionsFrom(pos, shortestRoute);
                    Iterator<Direction> it = list.iterator();
                    while (it.hasNext() && this.actionsLeft > 0) {
                        Direction dir = it.next();
                        this.client.send(this.message.move(dir));
                        pos.changeToCoordinateInDirection(dir);
                        --this.actionsLeft;
                    }
                } else {
                    System.out.println("Can't find any valuable resource on the map");
                    Direction direction = this.getSafeDirectionFrom(pos);
                    if (direction != null) {
                        this.client.send(this.message.move(direction));
                        this.actionsLeft = 0;
                    } else {
                        this.actionsLeft = 0;
                    }
                }
            }
            if (this.actionsLeft > 0) {
                this.upgradeWeaponsIfPossible();
            }
            if (this.actionsLeft > 0 && target != null) {
                this.shootIfInRange(target);
            }
            if (this.actionsLeft > 0) {
                this.mineCurrentTileIfNeeded();
            }
            if (this.actionsLeft <= 0) continue;
            if (dirSequence == null && target != null) {
                dirSequence = this.getDirectionSequenceTowards(this.actionsLeft, pos, target);
            }
            if (dirSequence != null && index < dirSequence.size()) {
                Direction dir = dirSequence.get(index);
                this.client.send(this.message.move(dir));
                pos.changeToCoordinateInDirection(dir);
                --this.actionsLeft;
                ++index;
                continue;
            }
            this.actionsLeft = 0;
        }
    }

    private void upgradeWeaponsIfPossible() throws JsonProcessingException {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        WeaponBean[] weapons = new WeaponBean[]{currentPlayer.getPrimaryWeapon(), currentPlayer.getSecondaryWeapon()};
        PlayerResources playerResources = this.game.getResources().getPlayerResources(this.aiName);
        int i = 0;
        while (i < weapons.length) {
            if (playerResources.upgradeWeaponIfPossible(weapons[i])) {
                WeaponType type = weapons[i].getType();
                this.client.send(this.message.upgrade(type));
                weapons[i].setLevel(weapons[i].getLevel() + 1);
                System.out.println("upgraded " + type.toString());
                --this.actionsLeft;
            }
            ++i;
        }
    }

    private void shootIfInRange(Coordinate target) throws JsonProcessingException {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        Coordinate pos = currentPlayer.getPosition();
        WeaponBean[] weapons = this.weaponsSortedByDamage(currentPlayer);
        int i = 0;
        while (i < weapons.length && this.actionsLeft > 0) {
            WeaponType weaponType = weapons[i].getType();
            switch (weaponType) {
                case DROID: {
                    List<Direction> sequence;
                    int droidRange = GameConstants.DROID_RANGE[weapons[i].getLevel() - 1];
                    if (!pos.hasRangeTo(target, droidRange) || (sequence = this.getDirectionSequence(droidRange, pos, target)) == null) break;
                    this.client.send(this.message.droidAttack(sequence));
                    this.actionsLeft = 0;
                    break;
                }
                case LASER: {
                    int laserRange = GameConstants.LASER_RANGE[weapons[i].getLevel() - 1];
                    if (!pos.hasDirectRangeTo(target, laserRange)) break;
                    Direction dir = pos.getDirectionTowards(target);
                    this.client.send(this.message.laserAttack(dir));
                    this.actionsLeft = 0;
                    break;
                }
                case MORTAR: {
                    int mortarRange = GameConstants.MORTAR_RANGE[weapons[i].getLevel() - 1];
                    if (!pos.hasRangeTo(target, mortarRange)) break;
                    Coordinate mortarCoord = pos.getRelativeCoordinateTo(target);
                    this.client.send(this.message.mortarAttack(mortarCoord));
                    this.actionsLeft = 0;
                    break;
                }
            }
            ++i;
        }
    }

    private void mineCurrentTileIfNeeded() throws JsonProcessingException {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        Coordinate pos = currentPlayer.getPosition();
        Tile tile = this.game.getTilemap().getTileAt(pos);
        if (tile != null && tile.isMineable() && this.needResource(tile)) {
            Resources resources = this.game.getResources();
            int resourceCount = resources.getResourceCountAt(pos);
            while (this.actionsLeft > 0 && resourceCount > 0) {
                this.client.send(this.message.mine());
                resources.decrementResourceCountAt(pos);
                resources.getPlayerResources(this.aiName).incrementResourceCount(tile);
                --resourceCount;
                --this.actionsLeft;
            }
        }
    }

    private boolean needResource(Tile resource) {
        PlayerBean currentPlayer = this.game.getCurrentPlayer();
        WeaponBean weapon1 = currentPlayer.getPrimaryWeapon();
        WeaponBean weapon2 = currentPlayer.getSecondaryWeapon();
        WeaponResource weaponResource = WeaponResource.getInstance();
        Tile resource1 = weaponResource.getResource(weapon1.getType());
        Tile resource2 = weaponResource.getResource(weapon2.getType());
        int maxLevel = 3;
        return resource == resource1 && weapon1.getLevel() < maxLevel || resource == resource2 && weapon2.getLevel() < maxLevel;
    }

    public static void main(String[] args) {
        Kaporder ai = new Kaporder();
        if (args.length == 2) {
            try {
                ai.setIp(args[0]);
                int port = Integer.parseInt(args[1]);
                ai.setPort(port);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Usage: Kaporder <ip> <port_number>");
            }
        }
        try {
            ai.start();
        }
        catch (IOException | SkyportException e) {
            System.out.println(e.getMessage());
        }
    }
}

