package skyport.enums;

public enum Tile {
	GRASS('G'),
	VOID('V'),
	SPAWN('S'),
	EXPLODIUM('E'),
	RUBIDIUM('R'),
	SCRAP('C'),
	ROCK('O');

	private final char type;

	private Tile(char type) {
		this.type = type;
	}

	public char toChar() {
		return type;
	}

	public boolean isTraversable() {
		switch (this) {
		case VOID:
		case SPAWN:
		case ROCK:
			return false;
		default:
			return true;
		}
	}

	public boolean isMineable() {
		switch (this) {
		case EXPLODIUM:
		case RUBIDIUM:
		case SCRAP:
			return true;
		default:
			return false;
		}
	}

	public boolean blocksLaser() {
		return this == ROCK;
	}

	public boolean absorbsExplosiveDamage() {
		switch (this) {
		case ROCK:
		case VOID:
			return true;
		default:
			return false;
		}
	}
}
