package skyport.json;

import java.io.Serializable;

import skyport.enums.WeaponType;
import skyport.enums.WeaponTypeFactory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class WeaponBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private WeaponType type;
	private int level;

	public WeaponBean() {
		type = null;
		level = 0;
	}

	@JsonCreator
	public WeaponBean(@JsonProperty("name") final String name,
			@JsonProperty("level") int level) {

		this.type = WeaponTypeFactory.getInstance().getByString(name);
		this.level = level;
	}

	public WeaponType getType() {
		return type;
	}

	public void setType(WeaponType type) {
		this.type = type;
	}

	public String getName() {
		return type.toString();
	}

	public void setName(final String name) {
		this.type = WeaponTypeFactory.getInstance().getByString(name);
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}
}
