var skyport = require('../api/nodejs/skyport.js')
  , mapSizeJ = 0
  , mapSizeK = 0
  , mapData = []
  , playerData = []
  , tileTypes = { grass: 'G'
                , empty: 'V'
				, spawn: 'S'
				, explodium: 'E'
				, rubidium: 'R'
				, scrap: 'C'
				, rock: 'O'
				}
  , directions = { u: { c:"up", dJ:-1, dK:-1 }
				 , d: { c:"down", dJ:1, dK:1 }
				 , lu: { c:"left-up", dJ:0, dK:-1 }
				 , ld: { c:"left-down", dJ:1, dK:0 }
				 , ru: { c:"right-up", dJ:-1, dK:0 }
				 , rd: { c:"right-down", dJ:0, dK:1 }
				 }
  , myPos = {}
  , primary = { level: 1
              , nextLevel: 4
			  }
  , secondary = { level: 1
                , nextLevel: 4
				}
  , movesRemaining = 0

if(process.argv.length != 3){
    console.log("Usage: node randomwalker.js name_of_the_bot");
    process.exit();
}

var myname = process.argv[2];

function got_connection() {
    console.log("got connection, sending handshake...")
    connection.send_handshake(myname)
}

function got_handshake() {
	console.log("got handshake")
}

function got_gamestart(map, players) {
	var weaponChoices = { mortar: 0
                        , laser: 0
					    , droid: 0
					    }
    // randomly chose some weapons to use
	mapSizeJ = map['j-length']
	mapSizeK = map['k-length']
	mapData = map.data
	
	for (var i = 0; i < mapSizeJ; i++) {
		for (var j = 0; j < mapSizeK; j++) {
			if (mapData[i][j] === tileTypes.explodium) {
				weaponChoices.mortar++
			}
			
			else if (mapData[i][j] === tileTypes.rubidium) {
				weaponChoices.laser++
			}
			
			else if (mapData[i][j] === tileTypes.scrap) {
				weaponChoices.droid++
			}
		}
	}
	
	if (weaponChoices.mortar >= weaponChoices.laser 
		|| weaponChoices.mortar >= weaponChoices.droid) {
		if (weaponChoices.mortar >= weaponChoices.laser 
			&& weaponChoices.mortar >= weaponChoices.droid) {
			primary['weapon'] = 'mortar'
			primary['resource'] = tileTypes.explodium
			primary['fire'] = tryMortar
		}
		else {
			secondary['weapon'] = 'mortar'
			secondary['resource'] = tileTypes.explodium
			secondary['fire'] = tryMortar
		}
	}
	
	if (weaponChoices.laser >= weaponChoices.mortar 
		|| weaponChoices.laser >= weaponChoices.droid) {
		if (weaponChoices.laser >= weaponChoices.mortar 
			&& weaponChoices.laser >= weaponChoices.droid) {
			primary['weapon'] = 'laser'
			primary['resource'] = tileTypes.rubidium
			primary['fire'] = tryLaser
		}
		else {
			secondary['weapon'] = 'laser'
			secondary['resource'] = tileTypes.rubidium
			secondary['fire'] = tryLaser
		}
	}
	
	if (weaponChoices.droid >= weaponChoices.laser 
		|| weaponChoices.droid >= weaponChoices.mortar) {
		if (weaponChoices.droid >= weaponChoices.laser 
			&& weaponChoices.droid >= weaponChoices.mortar) {
			primary['weapon'] = 'droid'
			primary['resource'] = tileTypes.scrap
			primary['fire'] = tryDroid
		}
		else {
			secondary['weapon'] = 'droid'
			secondary['resource'] = tileTypes.scrap
			secondary['fire'] = tryDroid
		}
	}
	
    console.log("got gamestart");
    connection.send_loadout(primary.weapon, secondary.weapon)
}
function got_gamestate(turn_number, map, players){
	console.log("got gamestate")
	if(players[0]["name"] == myname) { // its our turn
		console.log("my turn!")
		myPos = getPosTupleFromString(players[0]['position'])
		mapData = map.data
		playerData = players

		executeMoves()
	}
}

// Will fire, and return true, if an enemy is within reach
function tryLaser(ref, enemyPos) {
	if (movesRemaining < 1) return
	
	for (var k in directions) {
		if (!directions.hasOwnProperty(k)) continue
		
		for (var i = 1; i <= (ref.level+4); i++) {
			var pos = { j:myPos.j + (i*directions[k].dJ), k:myPos.k + (i*directions[k].dK) }
			
			if (pos.j < 0 || pos.j >= mapSizeJ || pos.k < 0 || pos.k >= mapSizeK) break
			
			for (var j = 0; j < enemyPos.length; j++) {
				if (isSamePos(enemyPos[j], pos) 
					&& !(mapData[enemyPos[j].j][enemyPos[j].k] === tileTypes.spawn)) {
					fireLaser(directions[k])
					return true
				}
				
			}
		}
	}
	return false
}

function tryMortar(ref, enemyPos) {
	if (movesRemaining < 1) return
	
	var range = getCellsInRadiusFromSource(myPos, (1+ref.level))
	
	for (var i = 0; i < range.length; i++) {
		for (var j = 0; j < enemyPos.length; j++) {
			if (isSamePos(range[i], enemyPos[j])) {
				if (!(mapData[range[i].j][range[i].k] === tileTypes.spawn)) {
					fireMortar((range[i].j-myPos.j), (range[i].k-myPos.k))
					return true
				}
			}
		}
	}
	return false
}

function getCellsInRadiusFromSource(src, r) {
	var cells = [ src ]
	for (var i = 0; i < r; i++) {
		var newCells = []
		for (var j = 0; j < cells.length; j++) {
			for (var k in directions) {
				if (!directions.hasOwnProperty(k)) continue
				
				var newPos = { j:(cells[j].j + directions[k].dJ)
				             , k:(cells[j].k + directions[k].dK)
							 }
				
				if (newPos.j < 0 || newPos.j > mapSizeJ 
					|| newPos.k < 0 || newPos > mapSizeK)
					continue
				
				missing = true
				for (var l = 0; l < cells.length; l++) {
					if (isSamePos(newPos, cells[l])) {
						missing = false
						break
					}
				}
				if (missing) {
					newCells.push(newPos)
				}
			}
		}
		cells = cells.concat(newCells)
	}
	return cells
}

function tryDroid(ref, enemyPos) {
	if (movesRemaining < 1) return
	var nodes = getNodesWithinReach(ref.level+2)
	for (var i = 0; i < nodes.length; i++) {
		for (var j = 0; j < enemyPos.length; j++) {
			if (isSamePos(nodes[i], enemyPos[j])) {
				fireDroid(nodes[i].path)
				return true
			}
		}
	}
	return false
}

function isSamePos(pos1, pos2) {
	return (pos1.j===pos2.j) && (pos1.k===pos2.k)
}

function getPosTupleFromString(str) {
	return { j:Number(str.split(',')[0].trim())
	       , k:Number(str.split(',')[1].trim())
		   }
}

function executeMoves() {

	movesRemaining = 3
	var availMoves = getAvailableMoveDirections(myPos)
	  , enemyPos = getEnemyPos()
	  , enemyDir = enemyTooCloseForComfort(enemyPos)
	  
	if(mapData[myPos.j][myPos.k] === tileTypes.spawn) {
		move(availMoves[0])
		availMoves = getAvailableMoveDirections(myPos)
	}

	if(primary.nextLevel > 0 && mapData[myPos.j][myPos.k] === primary.resource) {
		mine(primary)
		console.log("Need " + primary.nextLevel + " more " + primary.resource + " for next level")
	}
	else if (secondary.nextLevel > 0 && mapData[myPos.j][myPos.k] === secondary.resource) {
		mine(secondary)
		console.log("Need " + secondary.nextLevel + " more " + secondary.resource + " for next level")
	}
	
	if (primary.nextLevel === 0) {
		upgrade(primary)
	}

	if (secondary.nextLevel === 0) {
		upgrade(secondary)
	}

	if (movesRemaining > 0) {
		primary.fire(primary, enemyPos)
		secondary.fire(secondary, enemyPos)
	}

	var node = bestMove(createUtilityList(getNodesWithinReach(mapSizeK), enemyPos))
	
	console.log("Chosen: ")
	console.log(node)
		
	for (var i = 0; i < node.path.length; i++) {
		move(node.path[i])
	}
}

function getNodesWithinReach(range) {
	var avail = [ ]
	var nodes = [ myPos ]
	myPos['path'] = []
	
	for (var i = 0; i < range; i++) {
		avail = nodes.slice()
		while (avail.length > 0) {
			var pos = avail.pop()
			var dirs = getAvailableMoveDirections(pos)
			while (dirs.length > 0) {
				var dir = dirs.pop()
				var newPos = { j:(pos.j+dir.dJ)
				             , k:(pos.k+dir.dK)
							 , path:(pos.path.concat(dir))
							 }
				var missing = true
				for (var j = 0; j < nodes.length; j++) {
					if (isSamePos(nodes[j], newPos)) {
						missing = false
						break
					}
				}
				if (missing) {
					nodes.push(newPos)
				}
			}
		}
	}
	
	return nodes
}

function createUtilityList(nodes, enm) {
	for (var i = 0; i < nodes.length; i++) {
		if (mapData[nodes[i].j][nodes[i].k]===primary.resource
			&& primary.nextLevel > 0 && nodes[i].path.length <= movesRemaining) {
			nodes[i]['util'] = 100
		}
		else if (mapData[nodes[i].j][nodes[i].k]===secondary.resource
			&& secondary.nextLevel > 0  && nodes[i].path.length <= movesRemaining) {
			nodes[i]['util'] = 50
		}
		else {
			nodes[i]['util'] = 0
		}
		for (var j = 0; j < enm.length; j++) {
			if (isSamePos(enm[j], nodes[i]) && nodes[i].path.length+1 > movesRemaining) {
				nodes[i]['util'] = (10-nodes[i].path.length)
			}
		}
		if (nodes[i].j===myPos.j && nodes[i].k===myPos.k) {
			nodes[i]['util'] -= 49
		}
	}
	
	var allPaths = getNodesWithinReach(mapSizeK)
		
	return nodes
}

function bestMove(list) {
	var node;
	var best = -10000
	var bestList = []
	
	for (var i = 0; i < list.length; i++) {
		if (list[i].util > best) {
			bestList = []
			node = list[i]
			best = node.util
			bestList.push(list[i])
		}
		else if (list[i].util === best) {
			bestList.push(list[i])
		}
	}
	return bestList[Math.floor(Math.random() * bestList.length)]
}

function getEnemyPos() {
	pos = []
	
	for(var i = 1; i < playerData.length; i++) {
		pos.push(getPosTupleFromString(playerData[i]['position']))
	}	
	
	return pos
}

function upgrade(weapon) {
	if (movesRemaining < 1) return
	
	console.log("Upgrading " + weapon.weapon)
    connection.upgrade(weapon.weapon)
	movesRemaining--
	weapon.level++
	weapon.nextLevel = (weapon.level < 3) ? (weapon.level+3) : -1
}
function mine(weap) {
	if (movesRemaining < 1) return
	console.log("Mining " + weap.resource + " from current tile")
	connection.mine()
	weap.nextLevel--
	movesRemaining--
}

// Returns an empty list if enemy is not too close, and a list of the
// directions of enemies that are too close if such enemies exist.
// An enemy is too close if he can hit me with a lv1 mortar without
// moving.
function enemyTooCloseForComfort(mov) {
	var enemyDir = []
	
	for(var i = 0; i < mov.length; i++) {
		if (Math.abs(mov[i].j-myPos.j) <=2 && Math.abs(mov[i].k-myPos.k) <= 2) {
			enemyDir.push(getDirectionFromTo(myPos, mov[i]))
		}
	}
	
	return enemyDir
}

function getDirectionFromTo(src, dst) {
	if (src.j < dst.j) {
		if(src.k < dst.k) {
			return directions.d.c
		}
		if (src.k === dst.k || src.k > dst.k) {
			return directions.ld.c
		}
	}
	
	if (src.j === dst.j) {
		if(src.k < dst.k) {
			return directions.rd.c
		}
		
		if (src.k > dst.k) {
			return directions.lu.c
		}
	}
	
	if (src.j > dst.j) {
		if (src.k > dst.k) {
			return directions.u.c
		}
		if (src.k === dst.k || src.k < dst.k) {
			return directions.ru.c
		}
	}
}

// Returns a list of legal moves from the given source tile
function getAvailableMoveDirections(src) {
	var neighbors = []
	
	if ((src.j+1) < mapSizeJ 
	  && mapData[src.j+1][src.k] !=tileTypes.empty
	  && mapData[src.j+1][src.k] !=tileTypes.spawn
	  && mapData[src.j+1][src.k] !=tileTypes.rock) {
		neighbors.push(directions.ld)
	}
	
	if ((src.j+1) < mapSizeJ
	  && (src.k+1) < mapSizeK
	  && mapData[src.j+1][src.k+1] !=tileTypes.empty
	  && mapData[src.j+1][src.k+1] !=tileTypes.spawn
	  && mapData[src.j+1][src.k+1] !=tileTypes.rock) {
		neighbors.push(directions.d)
	}
	
	if ((src.k+1) < mapSizeK
	  && mapData[src.j][src.k+1] !=tileTypes.empty
	  && mapData[src.j][src.k+1] !=tileTypes.spawn
	  && mapData[src.j][src.k+1] !=tileTypes.rock) {
		neighbors.push(directions.rd)
	}

	if ((src.j-1) >= 0
	  && mapData[src.j-1][src.k] !=tileTypes.empty
	  && mapData[src.j-1][src.k] !=tileTypes.spawn
	  && mapData[src.j-1][src.k] !=tileTypes.rock) {
		neighbors.push(directions.ru)
	}
	
	if ((src.j-1) >= 0
	  && (src.k-1) >= 0
	  && mapData[src.j-1][src.k-1] !=tileTypes.empty
	  && mapData[src.j-1][src.k-1] !=tileTypes.spawn
	  && mapData[src.j-1][src.k-1] !=tileTypes.rock) {
		neighbors.push(directions.u)
	}
	
	if ((src.k-1) >= 0
	  && mapData[src.j][src.k-1] !=tileTypes.empty
	  && mapData[src.j][src.k-1] !=tileTypes.spawn
	  && mapData[src.j][src.k-1] !=tileTypes.rock) {
		neighbors.push(directions.lu)
	}
	
	return neighbors
}

function move(dir) {
	if (movesRemaining < 1) return
	
	console.log("Moving " + dir.c)
    connection.move(dir.c)
	myPos.j += dir.dJ
	myPos.k += dir.dK
	movesRemaining--
}

function moveOpposite(mov, dir) {
	if (movesRemaining < 1) return
	
	switch(mov) {
		case "up":
			if (dir.indexOf(directions.d.c) > -1)
				move(directions.d)
			else if (dir.indexOf(directions.ld.c) > -1)
				move(directions.ld)
			else if (dir.indexOf(directions.rd.c) > -1)
				move(directions.rd)
			break;
		case "down":
			if (dir.indexOf(directions.u.c) > -1)
				move(directions.u)
			else if (dir.indexOf(directions.lu.c) > -1)
				move(directions.lu)
			else if (dir.indexOf(directions.ru.c) > -1)
				move(directions.ru)
			break;
		case "left-up":
			if (dir.indexOf(directions.rd.c) > -1)
				move(directions.rd)
			else if (dir.indexOf(directions.d.c) > -1)
				move(directions.d)
			else if (dir.indexOf(directions.ru.c) > -1)
				move(directions.ru)
			break;
		case "left-down":
			if (dir.indexOf(directions.ru.c) > -1)
				move(directions.ru)
			else if (dir.indexOf(directions.u.c) > -1)
				move(directions.u)
			else if (dir.indexOf(directions.rd.c) > -1)
				move(directions.rd)
			break;
		case "right-up":
			if (dir.indexOf(directions.ld.c) > -1)
				move(directions.ld)
			else if (dir.indexOf(directions.d.c) > -1)
				move(directions.d)
			else if (dir.indexOf(directions.lu.c) > -1)
				move(directions.lu)
			break;
		case "right-down":
			if (dir.indexOf(directions.lu.c) > -1)
				move(directions.lu)
			else if (dir.indexOf(directions.u.c) > -1)
				move(directions.u)
			else if (dir.indexOf(directions.ld.c) > -1)
				move(directions.ld)
			break;
	}
}

function fireLaser(dir) {
	if (movesRemaining < 1) return
	
	console.log("Firing mah lazor to " + dir.c)
    connection.attack_laser(dir.c)
	movesRemaining--
}
function fireMortar(j, k) {
	if (movesRemaining < 1) return

	console.log("Lobbing a mortar to the hex that is (" + j + ", " + k + ") relative to us")
	connection.attack_mortar(j, k) // j,k coordinates relative to our position
	movesRemaining--
}
function fireDroid(moveList) {
	if (movesRemaining < 1) return
	
	var moves = []
	
	for (var i = 0; i < moveList.length; i++) {
		moves.push(moveList[i].c)
	}
	
    console.log("Shooting the droid with moves " + moveList)
    connection.attack_droid(moves);
	movesRemaining--
}

function got_action(type, from, rest) {
	console.log("got action")
}

function got_error(message) {
	console.log("got error: '" + message + "'")
}

function got_endturn() {
	console.log("got endturn")
}

// Establish the connection
connection = new skyport.SkyportConnection("localhost", 54321)

// Register these callbacks. SkyportConnection will call the
// provided callback function when something of interest happens
connection.on('connection', got_connection)
connection.on('handshake', got_handshake)
connection.on('gamestart', got_gamestart)
connection.on('gamestate', got_gamestate)
connection.on('action', got_action)
connection.on('error', got_error)
connection.on('endturn', got_endturn)
connection.connect()
