#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer instanceData;

uniform vec3 distortPos;
uniform float distortAmount;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

vec3 rotateVector(in vec3 v, in vec4 q)
{
	vec3 uv = cross(q.xyz, v);
	vec3 uuv = cross(q.xyz, uv);
	uv *= 2.0 * q.w; 
	uuv *= 2.0;
	return v + uv + uuv;
}

vec3 distort(in vec3 pos)
{
	const float radius = 3.0;
	const float piovertwo = 3.1415926 / 2.0;

	vec3 p = pos - distortPos;
	float len = length(p);
	vec4 dv;
	dv.x = cos( (pos.x / radius) * piovertwo );
	dv.y = cos( (pos.y / radius) * piovertwo );
	dv.z = cos( (pos.z / radius) * piovertwo );
	float d = 1.0 - (len / radius);
	dv.xyz *= d * distortAmount;
	dv.w = 1.0 - dot(dv.xyz, dv.xyz);
	return rotateVector(p, dv) + distortPos;
}


void main()
{
	vec4 instData = texelFetch(instanceData, gl_InstanceID);

	vec4 pos = vec4(POSITION*instData.w + distort(instData.xyz), 1.0);

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	ec_pos = vec3(ModelViewMatrix * pos);

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
