varying vec3 norms;
varying vec4 verts;
void main()
{

	vec3 l  = normalize(lightPos  - worldPosition.xyz);
	vec3 l2 = normalize(lightPos2 - worldPosition.xyz);
	vec3 normal = normalize(worldPos);
	float diffuseAmt  = max(dot(norms, l), 0.);
	float diffuseAmt2 = max(dot(norms,l2), 0.);

	vec3 diffuseColor  = vec3(0.95) * diffuseAmt;
	vec3 diffuseColor2 = vec3(0.95) * diffuseAmt2;
	vec3 ambient = vec3(0.3,0.3,0.3);

	float shine = 1.0;
	vec3 e = normalize(eyevec);

	vec3 r  = reflect(-l,norms);
	vec3 r2 = reflect(-l2,norms);

	float spec  = pow(max(dot(r,e),0.9),shine);
	float spec2 = pow(max(dot(r2,e),0.0),shine);

	float maxFogDistance = mix(15.0,3.5,smoothstep(0.0,0.25,l.y));
	vec3 fogColor = getFogColor(viewPosition,lightPos,worldPosition.xyz);
	vec3 finalColor = mix(vec3(0.0),ambient + diffuseColor + diffuseColor2,clamp(l.y,0.0,0.85));

	gl_FragColor = vec4(0.1,0.1,0.1,1)* vec4(mix(finalColor, fogColor/1.5, clamp(length(viewPosition) / maxFogDistance-(l.y), 0.0, 0.7)), 1);
}