uniform mat4 Proj,View,World;
uniform vec3 LightPos;
uniform vec2 Mverts;
uniform vec2 Mtex;

void main()
{
	lightPos = LightPos;
	tCoords = gl_MultiTexCoord0.xy + Mtex;
	float height = terrainHeight(tCoords, 5);
	height += terrainHeight(tCoords/5.0,2)*5.5;
	worldPosition = World * vec4(gl_Vertex.x + Mverts.x, height, gl_Vertex.z + Mverts.y, gl_Vertex.w);
	gl_FrontColor = vec4(vec3(height),1.0);
	viewPosition = View * worldPosition;
	gl_Position = Proj * viewPosition;
}