ig.module( 
    'game.entities.coins' 
)
.requires(
    'impact.entity' 
)

.defines(function(){

// Play this when a character spawns in a or leaves a map.
EntityCoins = ig.Entity.extend({

    animSheet: new ig.AnimationSheet( 'media/coin.png', 32, 30 ),
    collides: ig.Entity.COLLIDES.NEVER,
    id: -1,
    zIndex: 5,
    size: {x: 32, y: 30},

    init: function( x, y, settings ) {
        this.parent(x, y, settings);

        this.id = settings.id;

        this.addAnim('default', 1, [0] );

        if(!ig.editor){
            // Re-sort Entities
            ig.game.sortEntitiesDeferred();
        }
    },
})
});