package useless.gui;

import javax.swing.*;
import useless.*;
import useless.gui.*;

import java.awt.*;
import java.awt.event.*;

public class MainWindow extends JFrame {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -7694289842209272916L;
	
	//Pane and text field
	private JScrollPane mainpanel;
	private JTextPane tfield;
	
	//Button and output
	private JButton btnCheck;
	private JLabel lblOutput;
	private JPanel bottomPanel;
	
	//Menubar
	private JMenuBar mainmenu;
	private JMenu filemenu;
	private JMenu helpmenu;
	private JMenuItem btnHelp;
	private JMenuItem btnExit;
	
	
	public MainWindow(String title) {
		//Call to super. Sets title.
		super(title);
		
		//Layout and size
		this.setLayout(new BorderLayout());
		this.setSize(800, 600);
		
		//Methods to set up various parts of the program
		setupMain();
		setupBtnOutput();
		setupMenuBar();
		
		//Defaults & etc.
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);
	}
	
	private void setupMain() {
		//Init
		tfield = new JTextPane();
		
		//Props
		mainpanel = new JScrollPane(tfield, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS ); 
		mainpanel.setSize(this.getSize());
		
		//Adding to the main frame
		this.add(mainpanel, BorderLayout.CENTER);
	}
	
	private void setupBtnOutput() {
		//Init
		btnCheck = new JButton("Check rage level");
		lblOutput = new JLabel("");
		bottomPanel = new JPanel();
		
		//Props
		bottomPanel.setLayout(new BorderLayout());
		
		//Event listeners
		btnCheck.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				TextChecker tcheck = new TextChecker(tfield.getText());
				lblOutput.setText("");
				lblOutput.setText(tcheck.checkForRage());
			}
		});
		
		//Adding to the frames
		bottomPanel.add(btnCheck, BorderLayout.WEST);
		bottomPanel.add(lblOutput, BorderLayout.CENTER);
		this.add(bottomPanel, BorderLayout.SOUTH);
	}
	
	private void setupMenuBar() {
		//Init
		mainmenu = new JMenuBar();
		filemenu = new JMenu();
		helpmenu = new JMenu();
		btnHelp = new JMenuItem();
		btnExit = new JMenuItem();

		//Setting labels
		filemenu.setText("Fil");
		btnExit.setText("Avslutt");
		helpmenu.setText("Hjelp");
		btnHelp.setText("Om programmet");
		
		//Event listening
		btnExit.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		btnHelp.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				new HelpWindow();
			}
		});
		
		//Adding the buttons
		filemenu.add(btnExit);
		helpmenu.add(btnHelp);
		mainmenu.add(filemenu);
		mainmenu.add(helpmenu);
		this.setJMenuBar(mainmenu);
	}
}
