#version 120

uniform vec4 EyePos;
uniform vec4 LightPos;

varying vec3 normal;
varying vec3 pos;


void main(void)
{
	float brightness = 1.0f - dot(normal, vec3(0.0f,1.0f,0.0f));
	vec3 sideColor = vec3(1.0f,2.0f,2.0f);
	
	vec3 lightPos = vec3(0.0f,1.0f,0.0f);
	vec3 vecToLight = lightPos - pos;
	vec3 vecToLightNorm = normalize(vecToLight);
	
	float attenuation = 1.0f / length(vecToLight);
	attenuation = smoothstep(0.0f, 3.5f, attenuation);
	
	float phong = pow(dot(vecToLightNorm, normal )*0.5f+0.5f,2.0f);

	gl_FragColor = vec4( brightness*sideColor + vec3(attenuation*phong )*sideColor, 1.0f );	
}