var FlowerParty = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback,
		_f,
		_s,
		_h;

	var _sAlpha,
		_sYoff,
		_sXoff,
		_blackFade,
		_glow,
        _fDiameter,
        _fRotation;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();

		//barHeight = _height/2.5;
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(42424242, 8000085, 1333337, 4242424);

		_h = new HexaGone();
		_h.setContext(_ctx);

		_s = new Starfield();
		_s.setContext(_ctx);
		_s.setCenter(_width / 2, _height / 3);

		_f = new Flower();
		_f.setContext(_ctx);
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');

		_sAlpha = _sync.getTrack('0:sAlpha');
		_sYoff = _sync.getTrack('0:sYOff');
		_sXoff = _sync.getTrack('0:sXOff');
		_fDiameter = _sync.getTrack('fDiameter');
		_fRotation = _sync.getTrack('fRotation');
	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#ffc100';
		_ctx.fillRect(0, 0, _width, _height);

		_ctx.save();
		_ctx.globalAlpha = .33;
		_h.render(0, 0, frameDelta * 0.001);
		_ctx.restore();

		_ctx.save();
		//_ctx.globalAlpha = .8;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_ctx.globalAlpha = .33;
		_s.render(frameDelta *0.01);
		_ctx.restore();

		_ctx.save();
        _f.setDiameter(_fDiameter.getValue(row));
        _f.setRotation(_fRotation.getValue(row));
		_f.render(frameDelta * 0.1, row);
		_ctx.restore();


		//_s.setCenter(offsetX, offsetY);
		//_s.render(frameDelta/100);

		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());