﻿//Base part


//duration: part length in ms
//startTime: the absolute time when the part starts
//endTime: time that part need for end effect in ms
var PartBase = function(){
  //Transformations that needs to be synced with music
  this.transformations = [];
  this.elapsed = 0;
}

//scene is initialized before demo starts
PartBase.prototype.initScene = function(){
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera(TDEMO.fov, TDEMO.aspect, TDEMO.near, TDEMO.far);
  this.scene.add(this.camera);
}

//prepare is called just before first rendering
PartBase.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
}

//rendering function
PartBase.prototype.render = function(elapsedTime, delta, rtt){
  this.predict(elapsedTime, delta);
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}

//Place of fast moving objects need to be predicted
//also music synck need to be done here
PartBase.prototype.predict = function(elapsedTime, delta){
}

//animation
//Operations that takes place in fixed timestep, 30FPS
PartBase.prototype.animate = function(timeStep, elapsedTime){
  this.elapsed += timeStep;
}

//Switches animation function
PartBase.prototype.switchAnimation = function(animation){
  this.animate = animation;
}

//--------------------------------------------------
// PROTOTYPAL INHERITANCE FUNCTION
//--------------------------------------------------
PartBase.prototype.inheritance = function(){
  function PartBasePrototype(){};
  PartBasePrototype.prototype = this;
  var created = new PartBasePrototype();
  return created;
};
