;GenerateTo "..\frameworc64.prg"

;*=$0801
;   byte $0b,$08,$0a,$00,$9e,$34,$39,$31,$35,$32,$00,$00,$00  ; 10 SYS49152




;  IMPORTANT NOTE!!!
;  THIS IS THE ORIGINAL SOURCE CODE OF FRAMEWORC64.
;  I MADE IT FOR AROK PARTY 2014.
;  
;  THE SOURCE CODE IS NOT OPTIMAL IN ANY SENSE. 
;  IT IS NOT FAST. NOT SMALL. NOT GOOD.
;  BUT IT WORKS. THE ONLY GOAL WAS TO
;  INTRODUCE THE FUNCTIONALITY OF FRAMEWORC64.
;  
;  YOU CAN USE THIS CODE FOR FREE, YOU CAN MODIFY IT
;  AS LONG AS YOU INFORM ME ABOUT THE FOLLOWINGS:
;  - WHAT IS YOUR PROJECT?
;  - WHAT MODIFICATIONS DO YOU WANT TO/DID YOU DO ON THIS CODE?
;  - HOW MUCH DO YOU LIKE FRAMEWORC64?
;  - HOW MUCH DOES IT HELP YOU IN YOUR WORK?
;  - YOU REFER TO ME IN YOUR PROJET'S MANUAL.
;  - YOU REFER TO FRAMEWORC64 IN YOUR PROJECT'S MANUAL.
;  IN ORDER TO INFORM ME, PLEASE SEND ME AN EMAIL:
;  CSONGOR@HALMAI.HU
;  THANKS.


;  HOW TO RUN IT:
;  LOAD"FRAMEWORC64",8,1
;  NEW
;  SYS 49152






*=$c000    
;--------------------------------------------------------
@init
        jmp @start                                  ;   

@setup_first_sprite_address
        jmp @setup_first_sprite_address_internal    ;      X=lower, Y=higher byte
 
@setup_sprite_pointer_address
        jmp @setup_sprite_pointer_address_internal  ;      X=lower, Y=higher byte

@setup_char_map_pointer
        jmp @setup_char_map_pointer_internal        ;      X=lower, Y=higher byte

@setup_char_dimension
        jmp @setup_char_dimension_internal          ;      X=width, Y=height byte

@put_char
        jmp @put_char_internal                      ;      X=x-coord, Y=y-coord, A=char_code

@clear
        jmp @clear_internal                         ;  

@init_8x8
        jmp @init_8x8_internal                      ; 

@init_4x6
        jmp @init_4x6_internal                      ; 

@put_pixel
        jmp @put_pixel_internal                     ;      X=x-coord, Y=y-coord, A=pixel color (0 or 1)
;--------------------------------------------------------
@first_sprite_address
        word $3f00  ; we will put the sprite patterns to the end of the 0th video bank

@sprite_pointer_address
        word $03f8  ; this is the 8-byte array where the 8 sprite pointers are

@char_map_pointer
        word $d800  ; points to the character shapes

@char_width
        byte 08

@char_height
        byte 08



*=$c040  ; sprite data must start at address which is k times $40

; original sprites without frame
@sprite1
        byte $ff,$c0,$00,$03,$a0,$00,$13,$80
        byte $00,$01,$f0,$00,$0d,$c0,$00,$1f
        byte $c0,$00,$1a,$60,$00,$0a,$70,$60
        byte $0e,$55,$68,$0f,$54,$60,$0d,$f0
        byte $00,$01,$e0,$00,$03,$c0,$00,$07
        byte $c0,$00,$07,$60,$00,$0e,$60,$00
        byte $0c,$60,$00,$0f,$78,$00,$00,$00
        byte $00,$00,$00,$00,$00,$00,$ff,$00
@sprite2
        byte $ff,$c0,$00,$03,$a0,$00,$13,$80
        byte $00,$01,$f0,$00,$0d,$c0,$00,$1f
        byte $c0,$00,$1a,$60,$00,$0a,$70,$60
        byte $0e,$55,$68,$0f,$54,$60,$0d,$f0
        byte $00,$01,$e0,$00,$00,$c0,$00,$00
        byte $c0,$00,$00,$c0,$00,$00,$c0,$00
        byte $00,$c0,$00,$00,$f0,$00,$00,$00
        byte $00,$00,$00,$00,$00,$00,$ff,$00
@sprite3
        byte $ff,$c0,$00,$03,$a0,$00,$13,$80
        byte $00,$01,$f0,$00,$0d,$c0,$00,$1f
        byte $c0,$00,$1a,$60,$00,$0a,$70,$60
        byte $0e,$55,$68,$0f,$54,$60,$0d,$f0
        byte $00,$01,$e0,$00,$03,$e0,$00,$03
        byte $f0,$00,$03,$38,$00,$07,$1c,$00
        byte $06,$0c,$00,$07,$8f,$00,$00,$00
        byte $00,$00,$00,$00,$00,$00,$ff,$00


*=$c100
;---------------------------------------------------------
@init_sprite
        lda #$fc     ; $21 = @sprite/64 (this point to the shape of the sprite)
        sta $07f8
        sta $07f9   
        
        lda #$f0     ; positioning second sprite in the borderless zone
        sta $d002
        lda #$38
        sta $d003

        lda #$29     ; positioning second sprite in the borderless zone
        sta $d000
        lda #$ff
        sta $d001

        lda #$ff
        sta $d010

        lda #$0d
        sta $d027    ; make it nice light green :)
        lda #$0a
        sta $d028    ; make it not-so-nice light pink :)

        lda #$03
        sta $d015    ; make the sprites visible

        lda #3
        sta $d017    ; sprite #2 double height
        sta $d01d
        rts
;---------------------------------------------------------

@init_interrupt
    sei
    
    lda @irqvec_1<
    sta $0314
    lda @irqvec_1>
    sta $0315
    
    lda #$1b        ; default screen size and others
    sta $d011
    lda #$30        ; let there be... interrupt in raster line 128
    sta $d012

    lda #$7f        
    sta $dc0d       ; disable all CIA#1 interrupt
    sta $dd0d       ; disable all CIA#2 interrupt
    
    lda #01
    sta $d01a       ; raster interrupt enabled

    lda $dc0d       ; no more timer interrupt
    lda $dd0d
    asl $d019       ; acknowledge all previous interrupts

    cli
    rts
;---------------------------------------------------------
@start
    jsr @init_sprite
    jsr @init_interrupt
    jsr @show_banner
    rts  ; return to the invoker, that is to the basic interpreter
;---------------------------------------------------------
@irqvec_1
    sei
    asl $d019        ; allow further interrupts

    lda @irqvec_2<   ; create new IRQ vector
    sta $0314
    lda @irqvec_2>
    sta $0315

    ldx $d012        ; use it 2 lines later ($80 => $82). It will trigger somewhere in the NOP sequence
    inx
    ldx #$32
    stx $d012
    lda $d020
    pha
    lda $07f9
    pha
    lda #$fc
    sta $07f9
    cli
    nop              ; give some time to trigger the interrupt
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    pla
    sta $07f9
    pla
    sta $d020
    lda @irqvec_1<   ; set back the original vector
    sta $0314
    lda @irqvec_1>
    sta $0315

    ldx #$30         ; set back the line number when to trigger it
    stx $d012

    jmp $ea31   ; do the usual system interrupt tasks
;---------------------------------------------------------
@irqvec_2
    asl $d019   ; allow further interrupts

    lda #$38
    sta $d003
    ldx $d021

    nop
    lda $ea     ; waste some time (3 cycles); Instead of "lda $44". Single "nop" would be too few (2 cycles), two "nop"s would be too much (3 cycles)
    
    lda $d012   
    cmp #$32
    beq @2      ; jumps to the same place in any cases. But if the condition holds then in takes 3 cycles, otherwise only 2. This time compensates the 1 cycle lag caused by NOP sequence
@2
    stx $d020
    ldx #$c0    ; value for 38 column mode
    ldy #$c8    ; value for 40 column mode
    nop
    stx $d016
    sty $d016

    jsr @delayed_hip_hop
    jsr @delayed_hip_hop
    jsr @delayed_hip_hop
    jsr @delayed_hip_hop
    jsr @delayed_hip_hop
    
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
        lda #$68
        sta $d003
        inc $07f9
        
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        nop
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        lda $ea

    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line

        lda #$98
        sta $d003
        inc $07f9
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        nop
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        lda $ea

    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line

        lda #$c8
        sta $d003
        inc $07f9

        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        nop
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        inc $d03f
        lda $ea
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line_plus_one_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line
    jsr @delayed_hip_hop_in_sprite_line

        ldx #$28         ; waiting till the end of the side-bordered section
@3
        dex
        bne @3

        lda #$38
        sta $d003
    pla         ; reset the stack which was filled by the Kernal before jumping by "jmp ($0314)"
    tay
    pla
    tax
    pla
    rti
;---------------------------------------------------------
@delayed_hip_hop
    lda $ea    ; do nothnign important. just wait....
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    nop        ; ... and wait...
    nop        ; ... and wait...

@hip_hop
    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode
    rts
;---------------------------------------------------------

@delayed_hip_hop_in_sprite_line
    lda $ea    ; do nothnign important. just wait....
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
        ;inc $d021               ;timing: inc+dec == 4*lda $ee
        ;dec $d021    


    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait... 
    nop        ; ... and wait...

    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode
    rts
;---------------------------------------------------------
@delayed_hip_hop_in_sprite_line_plus_one_line
    ; x=$c0, y=$c8

    lda $ea    ; do nothing important. just wait....
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    nop        ; ... and wait...

    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode

    lda $ea    ; ... and wait...  
    nop        ; ... and wait...  
    nop        ; ... and wait...

    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode

    rts
;---------------------------------------------------------
@delayed_hip_hop_in_sprite_line_plus_one_line_new_sprite
    ; x=$c0, y=$c8

    lda $ea    ; do nothing important. just wait....
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    lda $ea    ; ... and wait...
    nop        ; ... and wait...
    nop

    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode

    stx $d016    ; switch to 38 column mode
    sty $d016    ; switch to 40 column mode

    rts
;--------------------------------------------------------
@setup_first_sprite_address_internal
        stx @first_sprite_address
        sty @first_sprite_address+1
        rts
;--------------------------------------------------------
@setup_sprite_pointer_address_internal
        stx @sprite_pointer_address
        sty @sprite_pointer_address+1
        rts
;--------------------------------------------------------
@setup_char_map_pointer_internal
        stx @char_map_pointer
        sty @char_map_pointer+1
        rts
;--------------------------------------------------------
@setup_char_dimension_internal
        stx @char_width
        sty @char_height
        rts 
;--------------------------------------------------------
@clear_internal
        lda @first_sprite_address
        sta $fb
        lda @first_sprite_address+1
        sta $fc
        lda #$00
        ldy #$00
@8
        sta ($fb),y
        iny
        bne @8
        rts
;--------------------------------------------------------
@sprite_indexes_for_height_8  
        byte 0,0,0,1,1,1,2,2,2,3,3,3  ; if Y=0,1,2 then sprite#0, if Y=3,4,5 then sprite#1, etc
@sprite_offsets_for_height_8
        byte 0,24,48,0,24,48,0,24,48,0,24,48

@charmap_4x6 
        byte $40, $a0, $e0, $80, $40, $00    ; @
        byte $00, $00, $00, $00, $00, $00    ; a (missing)
        byte $00, $00, $00, $00, $00, $00    ; b (missing)
        byte $00, $00, $00, $00, $00, $00    ; c (missing)
        byte $00, $00, $00, $00, $00, $00    ; d (missing)
        byte $00, $00, $00, $00, $00, $00    ; e (missing)
        byte $00, $00, $00, $00, $00, $00    ; f (missing)
        byte $00, $00, $00, $00, $00, $00    ; g (missing)
        byte $00, $00, $00, $00, $00, $00    ; h (missing)
        byte $00, $00, $00, $00, $00, $00    ; i (missing)
        byte $00, $00, $00, $00, $00, $00    ; j (missing)
        byte $00, $00, $00, $00, $00, $00    ; k (missing)
        byte $00, $00, $00, $00, $00, $00    ; l (missing)
        byte $00, $00, $00, $00, $00, $00    ; m (missing)
        byte $00, $00, $00, $00, $00, $00    ; n (missing)
        byte $00, $00, $00, $00, $00, $00    ; o (missing)
        byte $00, $00, $00, $00, $00, $00    ; p (missing)
        byte $00, $00, $00, $00, $00, $00    ; q (missing)
        byte $00, $00, $00, $00, $00, $00    ; r (missing)
        byte $00, $00, $00, $00, $00, $00    ; s (missing)
        byte $00, $00, $00, $00, $00, $00    ; t (missing)
        byte $00, $00, $00, $00, $00, $00    ; u (missing)
        byte $00, $00, $00, $00, $00, $00    ; v (missing)
        byte $00, $00, $00, $00, $00, $00    ; w (missing)
        byte $00, $00, $00, $00, $00, $00    ; x (missing)
        byte $00, $00, $00, $00, $00, $00    ; y (missing)
        byte $00, $00, $00, $00, $00, $00    ; z (missing)
        byte $c0, $80, $80, $80, $c0, $00    ; [
        byte $00, $00, $00, $00, $00, $00    ;
        byte $60, $20, $20, $20, $60, $00    ; ]
        byte $00, $00, $00, $00, $00, $00    ;
        byte $00, $00, $00, $00, $00, $00    ;
        byte $00, $00, $00, $00, $00, $00    ;
        byte $40, $40, $40, $00, $40, $00    ; !
        byte $a0, $a0, $00, $00, $00, $00    ; "
        byte $a0, $60, $a0, $c0, $a0, $00    ; #
        byte $40, $a0, $40, $a0, $40, $00    ; $
        byte $a0, $20, $40, $80, $a0, $00    ; %
        byte $00, $00, $00, $00, $00, $00    ; & (missing)
        byte $40, $40, $00, $00, $00, $00    ; '
        byte $20, $40, $40, $40, $20, $00    ; (
        byte $80, $40, $40, $40, $80, $00    ; )
        byte $00, $a0, $40, $a0, $00, $00    ; *
        byte $00, $40, $e0, $40, $00, $00    ; +
        byte $00, $00, $00, $20, $40, $00    ; ,
        byte $00, $00, $e0, $00, $00, $00    ; -
        byte $00, $00, $00, $00, $80, $00    ; .
        byte $00, $20, $40, $80, $00, $00    ; /
        byte $e0, $a0, $a0, $a0, $e0, $00    ; 0
        byte $40, $40, $40, $40, $40, $00    ; 1
        byte $e0, $20, $e0, $80, $e0, $00    ; 2
        byte $e0, $20, $e0, $20, $e0, $00    ; 3
        byte $a0, $a0, $e0, $20, $20, $00    ; 4
        byte $e0, $80, $e0, $20, $e0, $00    ; 5
        byte $e0, $80, $e0, $a0, $e0, $00    ; 6
        byte $e0, $20, $20, $20, $20, $00    ; 7
        byte $e0, $a0, $e0, $a0, $e0, $00    ; 8
        byte $e0, $a0, $e0, $20, $e0, $00    ; 9
        byte $00, $40, $00, $40, $00, $00    ; :
        byte $00, $40, $00, $40, $80, $00    ; ;
        byte $20, $40, $80, $40, $20, $00    ; <
        byte $00, $e0, $00, $e0, $00, $00    ; =
        byte $80, $40, $20, $40, $80, $00    ; >
        byte $e0, $20, $40, $00, $40, $00    ; ?
        byte $00, $00, $00, $00, $00, $00    ;
        byte $40, $a0, $a0, $e0, $a0, $00    ; A
        byte $c0, $a0, $e0, $a0, $c0, $00    ; B
        byte $40, $a0, $80, $a0, $40, $00    ; C
        byte $c0, $a0, $a0, $a0, $c0, $00    ; D
        byte $60, $80, $c0, $80, $60, $00    ; E
        byte $60, $80, $c0, $80, $80, $00    ; F
        byte $60, $80, $c0, $a0, $60, $00    ; G
        byte $a0, $80, $e0, $a0, $a0, $00    ; H
        byte $40, $00, $40, $40, $40, $00    ; I
        byte $60, $20, $20, $20, $c0, $00    ; J
        byte $a0, $a0, $a0, $c0, $a0, $00    ; K
        byte $80, $80, $80, $80, $60, $00    ; L
        byte $c0, $e0, $e0, $a0, $a0, $00    ; M
        byte $c0, $a0, $a0, $a0, $a0, $00    ; N
        byte $40, $a0, $a0, $a0, $40, $00    ; O
        byte $c0, $20, $c0, $80, $80, $00    ; P
        byte $40, $a0, $a0, $40, $20, $00    ; Q
        byte $c0, $20, $c0, $a0, $a0, $00    ; R
        byte $60, $80, $40, $20, $c0, $00    ; S
        byte $e0, $40, $40, $00, $40, $00    ; T
        byte $a0, $a0, $a0, $a0, $c0, $00    ; U
        byte $a0, $a0, $a0, $a0, $40, $00    ; V
        byte $a0, $a0, $e0, $e0, $c0, $00    ; W
        byte $a0, $80, $a0, $40, $a0, $00    ; X
        byte $a0, $80, $a0, $40, $40, $00    ; Y
        byte $e0, $20, $40, $80, $e0, $00    ; Z

; puts the character from the A register to the X;Y coordinate with the adjusted charmap and char size.
; X,Y : position of the char (measured in char unit)
; A   : character code
; limitiation: at the moment only 8x8 characters are supported
@put_char_internal
        pha
        stx $fd
        sty $fe

        ldx @char_width
        ldy @char_height

        cpx #$08
        bne @not_8x8
        cpy #$08
        bne @not_8x8
        jmp @put_char_internal_8x8
@not_8x8
        cpx #$04
        bne @not_4x6
        cpy #$06
        bne @not_4x6
        jmp @put_char_internal_4x6
@not_4x6
        pla
        rts           ;  char size not (yet) supported
;--------------------------------------------------------
@put_char_internal_8x8
        lda @first_sprite_address
        sta $fb
        lda @first_sprite_address+1
        sta $fc

        ldy $fe
        lda @sprite_indexes_for_height_8,y
        tay
@8x8_6
        cpy #0
        beq @8x8_5
        
        clc
        lda $fb
        adc #64
        sta $fb
        lda $fc
        adc #0
        sta $fc
        dey
        jmp @8x8_6
@8x8_5

        ldy $fe
        clc
        lda $fb
        adc @sprite_offsets_for_height_8,y
        adc $fd
        sta $fb
        lda $fc
        adc #0
        sta $fc
         ; by this time ($fb) points to the first byte of the sprite where the char map has to be copied

        lda #00
        sta $fd
        sta $fe
        pla
        asl
        rol $fe 
        asl
        rol $fe 
        asl
        rol $fe 
        sta $fd     
         ; by this time ($fd) points to the character bytes relative to the character map

        clc
        adc @char_map_pointer
        sta $fd
        lda $fe
        adc @char_map_pointer+1
        sta $fe

        php
        sei
        lda #$01
        sta $01

        ldy #0
        ldx #0
@8x8_7
        lda ($fd),y
        sta $02
        tya
        pha
        txa
        tay
        lda $02
        sta ($fb),y
        pla
        tay
        iny
        inx
        inx
        inx
        cpy #8
        bne @8x8_7
        
        lda #$37
        sta $01 
        plp       

        rts
;--------------------------------------------------------
@a_times_char_height   ; $fd-$fe := a * char_height
        tax

        lda #00
        sta $fd
        sta $fe
        ldy @char_height        
@9
        txa
        clc 
        adc $fd
        sta $fd
        lda #$00
        adc $fe
        sta $fe
        dey
        bne @9
        rts
;--------------------------------------------------------
@sprite_indexes_for_height_6
        byte 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3
@sprite_offsets_for_height_6
        byte 0,18,36,0,18,36,0,18,36,0,18,36

        ; the following to constants tells for each possible X (=0...5) that 
        ; - in which byte of the sprite line and 
        ; - on which position of that byte 
        ; we have to start to copy the pixels of the character.
        ; For example, the 5th char in the row begins the 2nd byte and in its 4th bit:
        ; -------- -------- ----****
@sprite_inline_offsets_for_width_4
        byte 0,0,1,1,2,2
@bit_offsets_for_width_4    
        byte 0,4,0,4,0,4  

@put_char_internal_4x6
; X and Y ccordinates are stored in $fd and $fe. The char code is on the to of the stack.

        lda @first_sprite_address
        sta $fb
        lda @first_sprite_address+1
        sta $fc

        ldy $fe
        lda @sprite_indexes_for_height_6,y
        tay            ; Y=0...3 (which sprite?)
@4x6_6
        cpy #0
        beq @4x6_5
        
        clc
        lda $fb
        adc #64
        sta $fb
        lda $fc
        adc #0
        sta $fc
        dey
        jmp @4x6_6
@4x6_5
              ;by this time ($fb) points to the first byte of the sprite which we want to write in.
        ldy $fe
        clc
        lda $fb
        adc @sprite_offsets_for_height_6,y
        ldy $fd
        adc @sprite_inline_offsets_for_width_4,y
        sta $fb
        lda $fc
        adc #0
        sta $fc
          ; by this time ($fb) points to the first byte inside the sprite (inside the ROW) where the char map has to be copied

        lda @bit_offsets_for_width_4,y   ; in this column we start to copy the pixels
        sta $fa
        lda @char_width
        sta $f9
         
        pla
        jsr @a_times_char_height
          ; by this time ($fd) points to the first byte of the character relative to the character map
        clc
        lda $fd
        adc @char_map_pointer
        sta $fd
        lda $fe
        adc @char_map_pointer+1
        sta $fe
          ; by this time ($fd) points to the first byte (upmost row) of the character in the character map.

     
        php
        sei
        lda #$37            ; TODO: #$00
        sta $01

        ldy #0
@4x6_7
        lda ($fd),y
        jsr @copy_bits_to_sprites

        lda $fb
        clc
        adc #$03
        sta $fb
        lda $fc
        adc #$00
        sta $fc
        iny
        cpy @char_height
        bne @4x6_7
        
        lda #$37
        sta $01        
        plp
        rts
;--------------------------------------------------------
; copy the leftmost $f9 number of bits of AR so that the leftmost bit will be the column number $fa of the value pointed by ($fb).
;   - preserves:  X, Y, $f9, $fb, $fc
;   - destroys:   $f8, $57, $58
; example: 
;   lda #$05         ; we will copy the highest 5 bits
;   sta $f9
;   lda #RSTUV000  (where R, S, T, U, V are binary digits)
;   sta $f9          ; of this byte
;
;   ldx #$06         ; starting from the 6th position
;   stx $fa
;
;   ldx #$00         ; of $c000
;   stx $fb
;   ldx #$c0
;   stx $fc
;   jsr...
;   This will overwrite the existing bits according to the following pattern:
;    old values in $c000 and $c001: xxxxxxxx xxxxxxxx
;    new values                   : xxxxxxRS TUVxxxxx
;    column indexes:              : 01234567 89abcdef

@copy_bits_to_sprites
        sta $f8
        txa
        pha
        tya
        pha
        lda $fb
        pha
        lda $fc 
        pha
        
        
        ldy $f9      ; number of bits to shift out from input byte
        ldx $fa      ; column index where to put the bits  

@next_byte
        lda #$ff     ; bitmask for AND (original value AND $58 => erase all bits at modifiable positions)
        sta $58
        lda #$00     ; bitmask for OR  (original AND $58 OR $57 => set new bits)
        sta $57

@more_bits
        rol $f8      ; new bit to Carry
        rol $57      ; new bit to $57
        clc
        rol $58      ; erase a bit from $58
        inx
        dey
        beq @end_of_input
        cpx #$08
        beq @end_of_output
        jmp @more_bits
@end_of_input
        cpx #$08
        beq @11
        clc 
        rol $57
        sec
        rol $58
        inx
        jmp @end_of_input
        
@11
        ldy #$00
        lda ($fb),y
        and $58
        ora $57
        sta ($fb),y
        
        pla
        sta $fc
        pla 
        sta $fb
        pla
        tay
        pla
        tax
        rts
@end_of_output
        tya
        pha
        ldy #$00
        lda ($fb),y
        and $58
        ora $57
        sta ($fb),y
        inc $fb
        bne @10
        inc $fc
@10
        pla
        tay
        nop

        lda #$ff     ; bitmask for AND (original value AND $58 => erase all bits at modifiable positions)
        sta $58
        lda #$00     ; bitmask for OR  ( original AND $58 OR $57 => set new bits)
        sta $57
        ldx #$08

@more_bits_2
        rol $f8      ; new bit to Carry
        rol $57      ; new bit to $57
        clc
        rol $58      ; erase a bit from $58
        dex
        dey
        beq @end_of_input2
        jmp @more_bits_2
@end_of_input2       ; push up the new bits to the highest positions
        clc
        rol $57      ; new bit to $57
        sec
        rol $58      ; erase a bit from $58
        dex
        bne @end_of_input2      
        jmp @11
;@end_of_test
;        pla
;        pla
;        ldx $57
;        ldy $58
;        lda $f8
;        rts
;--------------------------------------------------------
@init_8x8_internal
        ldx #$00
        ldy #$d8
        jsr @setup_char_map_pointer

        ldx #$08
        ldy #$08
        jsr @setup_char_dimension
        jmp @init_all_dimensions

@init_4x6_internal
        ldx #<@charmap_4x6   ; @irqvec_1<
        ldy #>@charmap_4x6
        jsr @setup_char_map_pointer

        ldx #$04
        ldy #$06
        jsr @setup_char_dimension
@init_all_dimensions
        ldx #$00
        ldy #$3f
        jsr @setup_first_sprite_address
        
        ldx #$f8
        ldy #$07
        jsr @setup_sprite_pointer_address

        jmp @clear
;--------------------------------------------------------
@put_pixel_x_offset 
        byte 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2
@put_pixel_nullers
        byte %01111111,%10111111,%11011111,%11101111,%11110111,%11111011,%11111101,%11111110
@put_pixel_setters
        byte %10000000,%01000000,%00100000,%00010000,%00001000,%00000100,%00000010,%00000001

@put_pixel_internal
        pha
        lda @first_sprite_address
        sta $fb
        lda @first_sprite_address+1
        sta $fc
        sty $fd
        ldy #$00
@15
        cpy $fd
        beq @14 

        lda $fb
        clc
        adc #$03
        sta $fb
        lda $fc
        adc #$00
        sta $fc
        iny
        cpy #21
        beq @16
        cpy #42
        beq @16
        cpy #63
        beq @16
        jmp @15
@16
        clc
        lda $fb
        adc #$01
        sta $fb
        lda $fc
        adc #$00
        sta $fc
        jmp @15
@14
        txa
        lsr
        lsr
        lsr
        clc
        adc $fb
        sta $fb
        lda $fc
        adc #$00
        sta $fc
               ; by this point ($fb) points to the bye
        txa
        and #%00000111  ; X mod 7
        tax
        
        pla
        cmp #00
        beq @unset       
        
        ldy #$00
        lda ($fb),y
        ora @put_pixel_setters,x
        sta ($fb),y
        rts
@unset       
        ldy #$00
        lda ($fb),y
        and @put_pixel_nullers,x
        sta ($fb),y
        rts
;--------------------------------------------------------
@cls    lda #$20
        ldx #$00
@cls_2
        sta $0400,x
        sta $0500,x
        sta $0600,x
        sta $06e8,x
        dex
        bne @cls_2
        rts  
;--------------------------------------------------------
@wait
        lda #$05
        sta $fb
        ldx #$00
        ldy #$00
@wait_2
        dex
        bne @wait_2
        dey
        bne @wait_2
        dec $fb
        bne @wait_2
        rts
;--------------------------------------------------------
@show_banner
        jsr @cls

        ldx #@end_of_banner-@banner
@12
        lda @banner-1,x
        sta $044f,x
        dex
        bne @12
        jsr @clear
        jsr @wait
        
        lda @first_sprite_address
        sta $fb
        lda @first_sprite_address+1
        sta $fc

        ldy #$3f
@13
        lda @logo_F_letter,y
        sta ($fb),y
        dey
        bpl @13

        ldx #$06
        ldy #$00
        jmp $e50c   ; set cursor position
;--------------------------------------------------------
@banner
    byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,236,251,123,108,236,251,123,32,32,254,97
    byte 225,236,251,123,32,226,251,123,225,252,254,252,108,236,251,123,225,97,123,160,108,236,251,123,225,236,251,123,225,97,32,32,225,252,98,32,108,255,251,97
    byte 225,97,32,32,108,236,251,97,225,236,236,160,225,236,226,126,124,160,160,236,225,97,225,97,225,97,32,32,225,97,108,123,225,97,225,97,124,226,251,236
    byte 124,126,32,32,32,226,226,126,124,126,32,226,32,226,226,32,32,226,124,126,32,226,226,32,124,126,32,32,32,226,226,32,32,226,226,32,32,32,124,126
@end_of_banner

@logo_F_letter
        BYTE 224,0,63,248,0,255,252,3,252,255,255,248,255,255,240
        BYTE 247,255,224,240,255,0,240,0,0,240,0,0,240,0,0
        BYTE 252,0,0,254,3,0,255,254,0,255,248,0,241,192,0
        BYTE 240,0,0,240,0,0,240,0,0,240,0,0,240,0,0
        BYTE 240,0,0

