#version 330 core

in vec2 UV;
uniform sampler2D inputtex;
//uniform float KERNELW;
uniform float sigma;
uniform float iResolution;

out vec4 color;

vec4 glow(vec2 coord) {
#define KERNELW 8
    vec4 summa = vec4(0.0);
    float pixely = 1.0 / iResolution;
    float sumnum = 0.0;
    for ( int y = -int(KERNELW)/2; y <= int(KERNELW)/2; y++) {
        //float weight = exp(-float(y * y) / (KERNELW / 0.2));
        float weight = exp(-float(y * y) / ((sigma * sigma)));
        vec2 uuz = coord + vec2(0.0, pixely * y);
        summa += weight * texture(inputtex, uuz);
        sumnum += weight;
    }
    return vec4(summa.rgb, 1.0) / sumnum;
}

void main(){
    vec3 blur = glow(UV).rgb;
    color = vec4(blur, 1.0);
}
