#version 330 core

layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexnormal;

out vec2 UV;
out vec3 normal;
out vec4 pos;
out vec3 origpos;
out vec4 MVpos;

uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;
uniform mat4 oldMVP;

void main(){
	// Transform vertices and textures.
	pos = MVP * vec4(vertexPos, 1.0);
	origpos = vertexPos;
	gl_Position =  pos;
	MVpos = V * M * vec4(vertexPos, 1.0);
	UV = vertexUV;

	// Vertex normal -juttua.
	vec4 transformednormal = transpose(inverse(V * M)) * vec4(vertexnormal, 0.0);
	normal = normalize(transformednormal.xyz);
}

