#version 330 core

// Interpolated values from the vertex shaders
in vec2 UV;
uniform sampler2D inputtex;
uniform float iGlobalTime;

vec3 mod289(vec3 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec2 mod289(vec2 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec3 permute(vec3 x) {
  return mod289(((x*34.0)+1.0)*x);
}

float snoise(vec2 v)
  {
  const vec4 C = vec4(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0
  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);
  vec2 i1;
  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;
  i = mod289(i);
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 )) + i.x + vec3(0.0, i1.x, 1.0 ));
  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;
  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );
  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 co(vec2 uv)
{
  // return sampler-compatible uv coords
//    uv.y = -uv.y; // Remove this if image is upside down (tends to happen with video)
    return 0.5-uv*0.49;
}


vec4 spacepochdist(sampler2D tex) {
  vec2 uv = 1.0 - 2.0 * UV;
  vec4 c;
  
  const int N = 32;
  float f = 1.0/float(N);
  for(int i = 0; i < N; ++i)
  {
    // sample texture
    c.x += f*texture2D(tex, co(uv) ).x;
    c.y += f*texture2D(tex, co(1.012*uv) ).y;
    c.z += f*texture2D(tex, co(1.019*uv) ).z;
    // distort radially
    uv /= 1.0 + ( f*(0.03+0.0005*sin(iGlobalTime*12.0)*rand(uv) ) );
  }
  // vignette and flicker
  float v  = 1.5 / pow(1.0 + 0.05*dot(uv, uv), 5.0); 
  float tv = 0.99+0.003*sin(60.0*iGlobalTime);
  return vec4( tv*c*v-0.1 );
}

// output
layout(location = 0) out vec4 color;

void main(){
	if( UV.y < 0.1222 || UV.y > 0.8777) {
		color = vec4(vec3(0.0), 1.0);
	} else {
		vec4 op = spacepochdist(inputtex);
		op += vec4( 0.01*vec3(rand(UV * vec2(iGlobalTime) )), 1.0 );
		op += vec4( 0.035*vec3(snoise(UV*333.3 + vec2(iGlobalTime*1000.0) )), 1.0 );
		color = vec4(op.rgb,
		             dot(op.rgb, vec3(0.2126, 0.7152, 0.0722)));
	}
}
