#version 330 core

in vec2 UV;
uniform sampler2D inputtex;
layout (location = 0) out vec4 color;
const int kTexSize = 64;
const float kTexScale = 1.0 / float(kTexSize);

void main() {
	vec2 coord = (UV - vec2(0.5)) * 2.0;
	coord = UV + vec2(1.0);
	color = vec4(0.0,0.0,0.0,1.0);
    for ( int i = 0; i < kTexSize; i++ ) {
    	for ( int j = 0; j < kTexSize; j++ ) {
    		vec2 texcoord = vec2(float(i), float(j)) * kTexScale;
    		float lifetime = texture(inputtex, texcoord).b;
    		float scalar = -lifetime * (lifetime - 1.0);
    		color += 5.0 * scalar * exp(-32.0 * length(UV - texture(inputtex, texcoord).xy)) / 128.0;
    	}
    }
//    color = vec4(UV, 0.0,1.0);
}
