var Rainbow = function() {
  this.rainbowObj = new THREE.Object3D();
  
  var ringGeom;
  var ringsystem;
  
  ringGeom = this.createRing(300,30,10000 /*13000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0xff0000}) );
  this.rainbowObj.add(ringsystem);
  
  ringGeom = this.createRing(275,30,9000 /*20000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0xFF7F00}) );
  this.rainbowObj.add(ringsystem);
  
  ringGeom = this.createRing(250,30,9000 /*20000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0xffff00}) );
  this.rainbowObj.add(ringsystem);

  ringGeom = this.createRing(230,30,8000 /*13000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0x00ff00}) );
  this.rainbowObj.add(ringsystem);
  
  ringGeom = this.createRing(210,20,8000 /*11000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0x0000ff}) );
  this.rainbowObj.add(ringsystem);
  
  ringGeom = this.createRing(195,20,8000 /*11000*/);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0x4B0082}) );
  this.rainbowObj.add(ringsystem);

  ringGeom = this.createRing(182,20,8000);
  ringsystem = new THREE.ParticleSystem( ringGeom, new THREE.ParticleBasicMaterial({color: 0x8B00FF}) );
  this.rainbowObj.add(ringsystem);
  
  return this.rainbowObj;
}

Rainbow.prototype.createRing = function(outer, inner, particleAmount){
  var geom = new THREE.Geometry();

  for(i=5; i<=particleAmount; i++) {
  
    var p = new THREE.Vector3();

    p.x = Math.sin(i) * outer + Math.random() * inner;
    p.y = Math.cos(i) * outer + Math.random() * inner;
    p.z = Math.sin(i) * outer + Math.random() * inner;
    
    geom.vertices.push( p );
  }
  return geom;
}
  
  
