//Namespace
this.wideload = this.wideload || {};

/**
* Main class for each part of the demo
*/

(function(){
	
	
	/**
	* Constructor
	* @param main Reference to main class
	* @param renderCacheAmount Amount of frames the part should cache in ringbuffer.
	*/
	var BasePart = function(main, partId){
		this.partId = partId;
		this.main = main;
		this.elapsedtime = 0;
		this.lastUpdate = 0;
		
		this.godrays = {
			enabled: false
		};
		this.bloom = {
			enabled: true,
			strength: 2.5
		};
	}
	//Expose the class.
	wideload.BasePart = BasePart;
	
	var p = BasePart.prototype;
	
	p.preInitialize = function(container){
		this.container = container;
	}

	/**
	* Initialize the part. This is called during page load.
	*/
	p.initialize = function(scene,container){
		this.scene = scene;
		if(container != undefined){
			this.container = container;	
		}
		
	}
	
	p.start = function(elapsedTime){
		this.isActive = true;
		this.container.visible=true;
		this.startTime = elapsedTime;
	}

	p.stop = function () {
		this.isActive = false;
		this.container.visible = false;
	}
	
	/**
	* Main controller calls render function
	* @param elapsedtime The elapsed song time.
	*/
	p.update = function(elapsedtime, partial){
		if(this.isActive){
			this.elapsedtime = elapsedtime-this.lastUpdate;	
			this.internalUpdate(elapsedtime, partial);	
		}
		
		
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){

	}
	
}())