/**
 * ...
 */

(function() {
	var Clock = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Clock.prototype = new wideload.BasePart();
	wideload.Clock = Clock;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene, container){
		this.superInitialize(scene,container);
		this.done = false;
		var holedPlaneShape = new THREE.Shape();
		holedPlaneShape.moveTo(  300, 0 );
		holedPlaneShape.lineTo(  110, 0 );
		holedPlaneShape.lineTo( 110, 20 );
		holedPlaneShape.lineTo(  100, 20 );
		holedPlaneShape.lineTo(  100, 0 );
		holedPlaneShape.lineTo(  -100, 0 );
		holedPlaneShape.lineTo(  -100, 200 );
		holedPlaneShape.lineTo(  300, 200 );
		holedPlaneShape.lineTo(  300, 0 );
		var extrudeSettings = {	amount: 2,  bevelEnabled: false};

		var plane = holedPlaneShape.extrude( extrudeSettings );

		var wall = new THREE.Mesh(plane, new THREE.MeshBasicMaterial({color:0x000000}));

		var door = new THREE.Mesh(new THREE.PlaneGeometry(10,20,2),new THREE.MeshBasicMaterial({color:0xc0c0c0}));
		door.position.y = 10;

		wall.position.x = -105;
		this.container.add(wall);
		this.container.add(door);

		this.makeClock();
		this.showZeroThirty();
	}

	p.showZeroThirty = function(){
		this.clear();
		this.setOn(0,[0,1,2,4,5,6]);
		this.setOn(1,[0,1,3,5,6]);
		this.setOn(2,[0,2,3,5,6]);
		this.setOn(3,[0,1,2,4,5,6]);
	}

	p.showZeroThirtyOne = function(){
		this.clear();
		this.setOn(0,[0,1,2,4,5,6]);
		this.setOn(1,[0,1,3,5,6]);
		this.setOn(2,[0,2,3,5,6]);
		this.setOn(3,[2,5]);
	}

	p.clear = function(){
		for(var i = 0; i < this.digits.length;++i){
			for(var j = 0; j < this.digits[i].length;++j){
				this.digits[i][j].material.color.setHex(0x080000);
				//this.digits[i][j].material.needsUpdate=true;
			}
		}
	}

	p.setOn = function(digit,digits){
		for(var i = 0; i < digits.length;++i){
			//console.log(digit + " " + digits);
			this.digits[digit][digits[i]].material.color.setHex(0xff0000);
			//this.digits[digit][digits[i]].material.needsUpdate = true;
		}
	}

	p.makeClock = function(geometry){

		var extrudeSettings = {	amount: 4,  bevelEnabled: false};

		var digitalClockShape = new THREE.Shape();
		digitalClockShape.moveTo(0,0);
		digitalClockShape.lineTo(-2,2);
		digitalClockShape.lineTo(-2,20);
		digitalClockShape.lineTo(0,22);
		digitalClockShape.lineTo(2,20);
		digitalClockShape.lineTo(2,2);
		digitalClockShape.lineTo(0,0);

		var digitalClockPanel = digitalClockShape.extrude(extrudeSettings);
		var digits = [];
		for(var i = 0; i < 4; ++i){
			digits[i] = new Array();
			for(var j = 0; j < 7;++j){
				var mesh = new THREE.Mesh(digitalClockPanel,new THREE.MeshBasicMaterial({color:0xff0000}));
				digits[i][j] = mesh;
				this.container.add(mesh);
				var spacing = 50;
				if(j==0){
					mesh.rotation.z = Math.PI/180*90;
					mesh.position.x = -55+i*spacing;
					mesh.position.y = 135;
				}
				if(j==1){
					mesh.position.x = -80+i*spacing;
					mesh.position.y = 110;
				}
				if(j==2){
					mesh.position.x = -50+i*spacing;
					mesh.position.y = 110;
				}
				if(j==3){
					mesh.rotation.z = Math.PI/180*90;
					mesh.position.x = -55+i*spacing;
					mesh.position.y = 105;
				}
				if(j==4){
					mesh.position.x = -80+i*spacing;
					mesh.position.y = 80;
				}
				if(j==5){
					mesh.position.x = -50+i*spacing;
					mesh.position.y = 80;
				}
				if(j==6){
					mesh.rotation.z = Math.PI/180*90;
					mesh.position.x = -55+i*spacing;
					mesh.position.y = 75;
				}
			}
		}
		this.digits = digits;
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
		if(elapsedtime-this.startTime > 2500 && !this.done){
			this.showZeroThirtyOne();
		}
		
	}
})();