/**
 * ...
 * @author rimina
 */
wideload.DayAndNightShader =
{
	attributes:{
		
	},
	
	uniforms:{
		nightScene: {type:"t", value: undefined},
		dayScene: {type:"t", value: undefined},
    lightPosition: {type: "v3", value : undefined}
	},
	
	vertex: [
		"varying vec3 vNormal;",
    "varying vec2 vUv;",
		
		"void main() {",
			"vNormal = normal;",
      "vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4(position,1.0);",
		"}"
	].join("\n"),
	
	fragment:[
		"varying vec3 vNormal;",
    "varying vec2 vUv;",
    "uniform sampler2D nightScene;",
		"uniform sampler2D dayScene;",
    "uniform vec3 lightPosition;",
    
		"void main() {",
      "float angle = dot(vNormal, lightPosition);",
      "vec4 night = texture2D(nightScene, vUv);",
      "vec4 day = texture2D(dayScene, vUv);",
      "gl_FragColor = mix(day, night, smoothstep(-0.25, 0.25, angle));",
      
		"}"
	].join("\n")
}