/**
 * ...
 * @author Henri Sarasvirta
 */
wideload.EarthShader =
{
	attributes:{
		
	},
	
	uniforms:{
		time: {type:"f", value: 164.0},
		"normal":	{ type: "t", value: null },
		"texture":	{ type: "t", value: null },
		"heightmap":	{ type: "t", value: null },
	},
	
	vertex: [
		"varying vec3 vNormal;",
		"varying vec2 vUv;",
		"varying vec3 vPosition;",
		"uniform sampler2D heightmap;",
		"varying float dep;",
		
		'float getDepth(){',
			'vec4 tex = texture2D(heightmap, vUv);',
			'return tex.r;',
		'}',
		
		"void main() {",
			'vUv = uv;',
			"vNormal = normal;",
			"vec3 p = position;",
			'dep = getDepth()-0.5;',
			'p.z += dep*250.0;//*250.0;',
			"vPosition = p;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
		"#extension GL_OES_standard_derivatives : enable",
		"varying vec3 vPosition;",
		"varying vec2 vUv;",
		"varying vec3 vNormal;",
		"uniform vec3 uLight;",
		"uniform vec2 resolution;",
		"uniform float time;",
		"uniform sampler2D texture;",
		"uniform sampler2D normalMap;",
		"varying float dep;",
		
		'vec3 getNormal() {',
			'// Differentiate the position vector',
			'vec3 dPositiondx = dFdx(vPosition);',
			'vec3 dPositiondy = dFdy(vPosition);',
			'float depth = texture2D(normalMap, vUv*10.0).r;',
			'float dDepthdx = dFdx(depth);',
			'float dDepthdy = dFdy(depth);',
			'dPositiondx -= 2.0 * dDepthdx * vNormal;',
			'dPositiondy -= 2.0 * dDepthdy * vNormal;',
			'//return vec3(0.0);',
			// The normal is the cross product of the differentials
			'return normalize(cross(dPositiondx, dPositiondy));',
		'}',
		"float rand(vec2 co){",
			"return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);",
		"}",
		"void main() {",
			"vec2 uv = gl_FragCoord.xy;",
			'//vec4 color = texture2D(texture, vUv*180.0);',
			'vec4 dark = vec4(0, 0, 0, 1.0);',
			'vec3 normal = getNormal();',
			"float rnd = rand(vec2(time*0.01*uv.x, time*uv.y*0.01));",
			'vec4 color = vec4(rnd*0.1+0.2, rnd*0.1+0.27, rnd*0.1+0.1, 1.0);',
			'// Mix in diffuse light',
			'float diffuse = dot(normalize(uLight - vPosition), normal);',
			'diffuse = max(0.0, diffuse);',
			'color = mix(dark, color*(dep+0.5), 0.5 + 0.5 * diffuse);',
			
			'gl_FragColor = vec4(color);',
		"}"
	].join("\n")
}