/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Grass = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Grass.prototype = new wideload.BasePart();
	wideload.Grass = Grass;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene,container){
		this.superInitialize(scene,container);
		
		this.container.position.x = 0;
		this.container.position.y = 0
		this.container.position.z = -200;
		
		
		var grassMaterial = new THREE.ShaderMaterial( {
			fragmentShader: wideload.GrassShader.fragment,
			vertexShader: wideload.GrassShader.vertex,
			uniforms: wideload.GrassShader.uniforms,
			depthWrite: false
		});
		
		var tex = new THREE.Texture(Asset.getAsset("grass"));
		tex.wrapS = tex.wrapT = THREE.RepeatWrapping; 
		tex.needsUpdate = true;
		
		grassMaterial.uniforms.grass.value = tex;
		
		mirrorMesh = new THREE.Mesh(
					new THREE.PlaneGeometry( 5000 , 5000	 , 50, 50 ), 
					grassMaterial
				);
		
		mirrorMesh.rotation.x = - Math.PI * 0.5;
		this.container.add( mirrorMesh );
				
		this.container.position.y = -600;
		
		var loader = new THREE.OfflineJSONLoader();

		var container = this.container;
		/*
		loader.load(jsAsset_lightPost, function(geo,materials){
			materials[0].map = new THREE.Texture(Asset.getAsset("prosesseja"));
			materials[1].map = new THREE.Texture(Asset.getAsset("greetwood"));
			materials[0].needsUpdate = true;
			materials[1].needsUpdate = true;
			var mesh = new THREE.Mesh(geo, new THREE.MeshFaceMaterial(materials));
			mesh.position = new THREE.Vector3(0,0,0);
			mesh.scale.set(250,250,250);
			container.add(mesh);
			//post.materials[2].side = THREE.DoubleSide;
			//post.materials[2].needsUpdate = true;
		})
*/
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
		//THREE.AnimationHandler.update( elapsedtime );
		var delta = this.main.clock.getDelta();
    	var theta = this.main.clock.getElapsedTime();
		//this.animation.update(delta);
//		this.water.material.uniforms.time.value += 1.0 / 90.0;
		//this.main.renderer.render( this.main.scene, this.main.camera );
		THREE.AnimationHandler.update( delta );
	}
	
	
	
})();

