/**
 * ...
 * @author Henri Sarasvirta
 */

wideload.HayShader =
function(){

  return{
    attributes:{
    },
    
    uniforms:{
      zoom: {type:"f", value: 0.6},
      wind: {type:"v2", value: new THREE.Vector2(4,1)},
      color: {type:"v4", value: new THREE.Vector4(54.0/255.0,204.0/255.0,53.0/255.0,0.8)},
      time: {type:"f", value: 164.0},
      divider: {type: "f", value: 100.0}
    },
    
    vertex: [
      "uniform vec2 wind;",
      "uniform float divider;",
      "varying float height;",
      "void main() {",
        "vec3 p = position;",
        
        "float xoff =p.y == 0.0 ? 0.0 : (p.y*p.y/divider*wind.x);",
        "float zoff =p.y == 0.0 ? 0.0 : (p.y*p.y/divider*wind.y);",
        "p.x += xoff;",
        "p.z += zoff;",
        "p.y -= abs(xoff) + abs(zoff);",
        "height = p.y;",
        "gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
      "}"
    ].join("\n"),
    
    fragment:[
      "uniform float time;",
      "uniform vec4 color;",
      "varying float height;",
      "void main() {",
        "vec2 uv = gl_FragCoord.xy;",
        
        "gl_FragColor = (height/40.0+0.5)*color;",
      "}"
    ].join("\n")
  }
};