/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Noise = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Noise.prototype = new wideload.BasePart();
	wideload.Noise = Noise;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene,container){
		this.superInitialize(scene,container);
		this.shaderMaterial = new THREE.ShaderMaterial({
			uniforms: wideload.NoiseShader.uniforms,
			attributes: wideload.NoiseShader.attributes,
			vertexShader: wideload.NoiseShader.vertex,
			fragmentShader: wideload.NoiseShader.fragment,
			color: "white",
			side:THREE.DoubleSide
		});
		
		var planeGeom = new THREE.PlaneGeometry(1280, 720);
		var plane = new THREE.Mesh(planeGeom, this.shaderMaterial);
		this.container.add(plane);
		
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
    	this.shaderMaterial.uniforms.time.value = elapsedtime*0.0001+20;
    	this.shaderMaterial.uniforms.ttime.value = elapsedtime/1000;
	}
})();

